<?php
require_once 'auth.php';
require_once 'db.php';

// เช็กสิทธิ์ Admin เท่านั้น
if (!isAdmin()) {
    header("location: index.php");
    exit;
}

$error_msg = "";
$success_msg = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $prefix = $_POST['prefix'];
    $firstname = trim($_POST['firstname']);
    $lastname = trim($_POST['lastname']);
    $role = 'user'; // สิทธิ์เริ่มต้นเป็นครูทั่วไป

    // 1. เช็กว่า Username ซ้ำไหม
    $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->execute([$username]);
    if ($stmt->rowCount() > 0) {
        $error_msg = "ชื่อผู้ใช้ (Username) นี้มีอยู่ในระบบแล้ว";
    } else {
        try {
            // 2. สร้างข้อมูล Personnel (แบบย่อ) ก่อน เพื่อเอา ID
            $sql_pers = "INSERT INTO personnel (prefix, firstname, lastname, position_type, status, image) VALUES (?, ?, ?, 'ครู', 'ปกติ', 'default.png')";
            $stmt_pers = $conn->prepare($sql_pers);
            $stmt_pers->execute([$prefix, $firstname, $lastname]);
            $new_personnel_id = $conn->lastInsertId();

            // 3. สร้าง User Login ผูกกับ Personnel ID นั้น
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $sql_user = "INSERT INTO users (username, password, role, personnel_id) VALUES (?, ?, ?, ?)";
            $stmt_user = $conn->prepare($sql_user);
            $stmt_user->execute([$username, $hashed_password, $role, $new_personnel_id]);

            $success_msg = "สร้างบัญชีสำเร็จ! ส่ง Username/Password ให้ครูได้เลย";
        } catch (PDOException $e) {
            $error_msg = "เกิดข้อผิดพลาด: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>เพิ่มผู้ใช้งานใหม่ (เปิดบัญชี)</title>
    <link rel="icon" type="image/png" href="uploads/logo.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="fas fa-user-plus"></i> เปิดบัญชีผู้ใช้งานใหม่</h4>
                </div>
                <div class="card-body p-4">
                    
                    <?php if($error_msg): ?>
                        <div class="alert alert-danger"><?php echo $error_msg; ?></div>
                    <?php endif; ?>
                    
                    <?php if($success_msg): ?>
                        <div class="alert alert-success text-center">
                            <h5><i class="fas fa-check-circle"></i> <?php echo $success_msg; ?></h5>
                            <hr>
                            <p class="mb-1"><strong>ชื่อ:</strong> <?php echo "$prefix$firstname $lastname"; ?></p>
                            <p class="mb-1"><strong>Username:</strong> <?php echo $username; ?></p>
                            <p class="mb-3"><strong>Password:</strong> <?php echo $password; ?></p>
                            <a href="personnel.php" class="btn btn-secondary btn-sm">กลับหน้ารายชื่อ</a>
                            <a href="add_user.php" class="btn btn-primary btn-sm">เพิ่มคนต่อไป</a>
                        </div>
                    <?php else: ?>

                    <form method="POST">
                        <h5 class="text-muted mb-3">1. กำหนดรหัสเข้าใช้งาน</h5>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Username (เช่น เลขบัตรปชช.)</label>
                            <input type="text" name="username" class="form-control" required placeholder="ระบุชื่อผู้ใช้">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Password (รหัสผ่านเริ่มต้น)</label>
                            <input type="text" name="password" class="form-control" required placeholder="ระบุรหัสผ่าน">
                        </div>

                        <hr>
                        <h5 class="text-muted mb-3">2. ข้อมูลเบื้องต้นเจ้าของบัญชี</h5>
                        <div class="row g-2">
                            <div class="col-md-3">
                                <label class="form-label fw-bold">คำนำหน้า</label>
                                <select name="prefix" class="form-select">
                                    <option>นาย</option>
                                    <option>นาง</option>
                                    <option>นางสาว</option>
                                    <option>ว่าที่ร้อยตรี</option>
                                </select>
                            </div>
                            <div class="col-md-5">
                                <label class="form-label fw-bold">ชื่อจริง</label>
                                <input type="text" name="firstname" class="form-control" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">นามสกุล</label>
                                <input type="text" name="lastname" class="form-control" required>
                            </div>
                        </div>

                        <div class="mt-4 d-grid">
                            <button type="submit" class="btn btn-success btn-lg fw-bold">
                                <i class="fas fa-save"></i> สร้างบัญชี
                            </button>
                        </div>
                    </form>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
</body>
</html>