<?php require_once 'auth.php'; require_once 'db.php'; 
// รับค่าเดือนจาก URL (ถ้าไม่มี ให้เป็นเดือนปัจจุบัน)
$m = isset($_GET['m']) ? $_GET['m'] : date('m');
$months = ["01"=>"ม.ค.", "02"=>"ก.พ.", "03"=>"มี.ค.", "04"=>"เม.ย.", "05"=>"พ.ค.", "06"=>"มิ.ย.", 
           "07"=>"ก.ค.", "08"=>"ส.ค.", "09"=>"ก.ย.", "10"=>"ต.ค.", "11"=>"พ.ย.", "12"=>"ธ.ค."];
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>วันเกิดบุคลากร</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container bg-white p-4 rounded shadow-sm">
    <h3 class="mb-4"><i class="fas fa-birthday-cake text-success"></i> วันเกิดบุคลากร</h3>

    <div class="d-flex flex-wrap gap-2 mb-4">
        <?php foreach($months as $key => $name): ?>
            <a href="?m=<?php echo $key; ?>" class="btn <?php echo ($m==$key)?'btn-success':'btn-outline-secondary'; ?>">
                <?php echo $name; ?>
            </a>
        <?php endforeach; ?>
    </div>

    <div class="row g-3">
        <?php
        $stmt = $conn->prepare("SELECT * FROM personnel WHERE MONTH(birthdate) = ? AND status='ปกติ' ORDER BY DAY(birthdate) ASC");
        $stmt->execute([$m]);
        $hasData = false;

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $hasData = true;
            $day = date('d', strtotime($row['birthdate']));
            $age = date('Y') - date('Y', strtotime($row['birthdate']));
            
            echo '
            <div class="col-md-4 col-lg-3">
                <div class="card h-100 shadow-sm border-start border-5 border-success">
                    <div class="card-body d-flex align-items-center">
                        <div class="bg-light rounded-circle p-3 me-3 text-center text-success fw-bold" style="width: 50px; height: 50px; display:flex; align-items:center; justify-content:center;">
                            '.$day.'
                        </div>
                        <div>
                            <h6 class="card-title mb-0">'.$row['prefix'].$row['firstname'].' '.$row['lastname'].'</h6>
                            <small class="text-muted">'.$row['position_type'].' (อายุ '.$age.')</small>
                        </div>
                    </div>
                </div>
            </div>';
        }

        if (!$hasData) {
            echo "<div class='col-12 text-center text-muted py-5'>- ไม่มีวันเกิดในเดือนนี้ -</div>";
        }
        ?>
    </div>
</div>

<?php include 'footer.php'; ?>
</body>
</html>