<?php
require_once 'auth.php';
require_once 'db.php';

if (!isAdmin()) { die("Access Denied"); }

$type = isset($_GET['type']) ? $_GET['type'] : 'excel';
$report = isset($_GET['report']) ? $_GET['report'] : 'all';
$filename = "Report_" . $report . "_" . date('Ymd_His');

// ตั้งค่า Header ไฟล์
if ($type == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename.xls\"");
    echo '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="content-type" content="text/plain; charset=UTF-8"></head><body>';
} else {
    header("Content-Type: text/csv; charset=utf-8");
    header("Content-Disposition: attachment; filename=\"$filename.csv\"");
    $output = fopen("php://output", "w");
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF)); // BOM for UTF-8
}

// ฟังก์ชันช่วยแสดงผล
function outputData($headers, $data, $type, $output_handle = null) {
    if ($type == 'excel') {
        echo "<table border='1'><thead><tr style='background-color:#eee;'>";
        foreach ($headers as $h) echo "<th>$h</th>";
        echo "</tr></thead><tbody>";
        foreach ($data as $row) {
            echo "<tr>";
            foreach ($row as $cell) echo "<td>$cell</td>";
            echo "</tr>";
        }
        echo "</tbody></table>";
    } else {
        fputcsv($output_handle, $headers);
        foreach ($data as $row) fputcsv($output_handle, $row);
    }
}

// --- Logic การดึงข้อมูล ---
$headers = [];
$data = [];

// 1. กลุ่มรายชื่อบุคลากร (พื้นฐาน)
if (in_array($report, ['all', 'exec', 'teacher', 'gov_emp', 'emp', 'retire', 'birthday', 'dept', 'full_db'])) {
    
    $sql = "SELECT code, prefix, firstname, lastname, position_type, department, phone, email, birthdate, start_date FROM personnel WHERE is_deleted = 0 ";
    
    if ($report == 'exec') $sql .= " AND position_type IN ('ผู้อำนวยการ', 'รองผู้อำนวยการ')";
    elseif ($report == 'teacher') $sql .= " AND position_type IN ('ครู', 'ครูผู้ช่วย')";
    elseif ($report == 'gov_emp') $sql .= " AND position_type = 'พนักงานราชการ'";
    elseif ($report == 'emp') $sql .= " AND position_type NOT IN ('ผู้อำนวยการ', 'รองผู้อำนวยการ', 'ครู', 'ครูผู้ช่วย', 'พนักงานราชการ')";
    elseif ($report == 'retire') $sql .= " AND birthdate <= '" . (date('Y')-60)."-10-01' ";
    elseif ($report == 'birthday') $sql .= " ORDER BY MONTH(birthdate), DAY(birthdate)"; 
    elseif ($report == 'dept') $sql .= " ORDER BY department, firstname";
    
    if (!in_array($report, ['birthday', 'dept'])) $sql .= " ORDER BY position_type, firstname";

    $stmt = $conn->query($sql);
    $raw_data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $headers = ['รหัส', 'คำนำหน้า', 'ชื่อ', 'นามสกุล', 'ตำแหน่ง', 'กลุ่มสาระ/ฝ่าย', 'เบอร์โทร', 'อีเมล', 'วันเกิด', 'วันเริ่มงาน'];
    foreach($raw_data as $r) {
        $data[] = array_values($r);
    }

// 2. สถิติการมาทำงาน (Attendance - Full Log)
} elseif ($report == 'attendance_full') {
    $headers = ['วันที่', 'รหัสพนักงาน', 'ชื่อ-นามสกุล', 'เวลาเข้า', 'เวลาออก', 'สถานะ', 'หมายเหตุ'];
    $sql = "SELECT a.work_date, p.code, CONCAT(p.prefix, p.firstname, ' ', p.lastname) as fullname, 
            a.check_in, a.check_out, a.status, a.note 
            FROM attendance a 
            JOIN personnel p ON a.personnel_id = p.id 
            ORDER BY a.work_date DESC, a.check_in ASC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// 3. สรุปจำนวนบุคลากร (Counts)
} elseif ($report == 'summary_count') {
    $headers = ['ประเภทบุคลากร', 'จำนวน (คน)'];
    $sql = "SELECT position_type, COUNT(*) as count FROM personnel WHERE is_deleted=0 AND status='ปกติ' GROUP BY position_type ORDER BY count DESC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// 4. ระดับการศึกษา (Education)
} elseif ($report == 'education') {
    $headers = ['ระดับการศึกษา', 'จำนวน (คน)'];
    $sql = "SELECT pe.edu_level, COUNT(DISTINCT pe.personnel_id) 
            FROM personnel_education pe 
            JOIN personnel p ON pe.personnel_id = p.id 
            WHERE p.is_deleted=0 AND p.status='ปกติ' 
            GROUP BY pe.edu_level";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// ---------------- [ส่วนที่เพิ่มใหม่] ----------------

// 5. สถิติการมาทำงาน (เฉพาะสถานะ ปกติ/มาทำงาน)
} elseif ($report == 'attend_present') {
    $headers = ['วันที่', 'รหัส', 'ชื่อ-นามสกุล', 'เวลาเข้า', 'เวลาออก', 'สถานะ'];
    $sql = "SELECT a.work_date, p.code, CONCAT(p.prefix, p.firstname, ' ', p.lastname), a.check_in, a.check_out, a.status 
            FROM attendance a JOIN personnel p ON a.personnel_id = p.id 
            WHERE a.status = 'ปกติ' OR a.status = 'มาทำงาน' 
            ORDER BY a.work_date DESC, a.check_in ASC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// 6. สถิติการมาสาย
} elseif ($report == 'attend_late') {
    $headers = ['วันที่', 'รหัส', 'ชื่อ-นามสกุล', 'เวลาเข้า', 'หมายเหตุ'];
    $sql = "SELECT a.work_date, p.code, CONCAT(p.prefix, p.firstname, ' ', p.lastname), a.check_in, a.note 
            FROM attendance a JOIN personnel p ON a.personnel_id = p.id 
            WHERE a.status = 'สาย' 
            ORDER BY a.work_date DESC, a.check_in ASC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// 7. ประวัติการลา
} elseif ($report == 'leave_history') {
    $headers = ['วันที่เริ่ม', 'ถึงวันที่', 'รหัส', 'ชื่อ-นามสกุล', 'ประเภทการลา', 'เหตุผล', 'สถานะ'];
    $sql = "SELECT l.start_date, l.end_date, p.code, CONCAT(p.prefix, p.firstname, ' ', p.lastname), l.leave_type, l.reason, l.status 
            FROM leaves l JOIN personnel p ON l.personnel_id = p.id 
            ORDER BY l.start_date DESC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);

// 8. ประวัติการไปราชการ
} elseif ($report == 'travel_history') {
    $headers = ['วันที่เริ่ม', 'ถึงวันที่', 'รหัส', 'ชื่อ-นามสกุล', 'เรื่อง', 'สถานที่', 'สถานะ'];
    $sql = "SELECT t.start_date, t.end_date, p.code, CONCAT(p.prefix, p.firstname, ' ', p.lastname), t.topic, t.location, t.status 
            FROM official_travel t JOIN personnel p ON t.personnel_id = p.id 
            ORDER BY t.start_date DESC";
    $stmt = $conn->query($sql);
    $data = $stmt->fetchAll(PDO::FETCH_NUM);
}

// ส่งออกข้อมูล
outputData($headers, $data, $type, isset($output) ? $output : null);

if (isset($output)) fclose($output);
if ($type == 'excel') echo "</body></html>";
exit;
?>