<?php
require_once 'db.php';

$step = 1; // 1=ตรวจสอบข้อมูล, 2=ตั้งรหัสใหม่
$error = "";
$success = "";
$verify_id = "";
$verify_name = "";

// --- ส่วนทำงาน PHP ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. ขั้นตอนตรวจสอบ (Username + Email)
    if (isset($_POST['btnVerify'])) {
        $username = trim($_POST['username']);
        $email = trim($_POST['email']);

        try {
            // เช็กข้อมูลในฐานข้อมูล: Username ตรงกับ Email ของคนนั้นไหม
            $sql = "SELECT u.id, p.firstname, p.lastname, p.email 
                    FROM users u 
                    JOIN personnel p ON u.personnel_id = p.id 
                    WHERE u.username = ? AND p.email = ?";
            
            $stmt = $conn->prepare($sql);
            $stmt->execute([$username, $email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                // ข้อมูลถูกต้อง -> ไปขั้นตอนที่ 2
                $step = 2; 
                $verify_id = $user['id']; 
                $verify_name = $user['firstname'] . ' ' . $user['lastname'];
            } else {
                $error = "ไม่พบข้อมูล! กรุณาตรวจสอบ Username หรืออีเมลให้ถูกต้อง";
            }
        } catch (PDOException $e) { 
            $error = "ระบบขัดข้อง: " . $e->getMessage(); 
        }
    }

    // 2. ขั้นตอนบันทึกรหัสผ่านใหม่
    if (isset($_POST['btnReset'])) {
        $uid = $_POST['user_id'];
        $pass1 = $_POST['new_pass'];
        $pass2 = $_POST['confirm_pass'];

        if ($pass1 !== $pass2) {
            $error = "รหัสผ่านไม่ตรงกัน กรุณากรอกใหม่";
            $step = 2; // ให้แก้ใหม่
            $verify_id = $uid;
        } else {
            // บันทึกรหัสผ่านใหม่
            $hashed = password_hash($pass1, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            if ($stmt->execute([$hashed, $uid])) {
                $success = "เปลี่ยนรหัสผ่านเรียบร้อยแล้ว! กำลังกลับไปหน้าล็อกอิน...";
                echo "<script>
                    setTimeout(function(){ window.location='login.php'; }, 2000);
                </script>";
            } else {
                $error = "เกิดข้อผิดพลาดในการบันทึก";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>กู้คืนรหัสผ่าน - HR Maesai</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; display: flex; align-items: center; justify-content: center; height: 100vh; }
        .reset-card { max-width: 450px; width: 100%; border-radius: 12px; border: none; }
        .card-header { background: #198754; color: white; text-align: center; padding: 20px; border-radius: 12px 12px 0 0 !important; }
    </style>
</head>
<body>

<div class="card reset-card shadow-lg">
    <div class="card-header">
        <h4 class="mb-0 fw-bold"><i class="fas fa-lock"></i> กู้คืนรหัสผ่าน</h4>
        <small>ระบบบริหารงานบุคคล โรงเรียนแม่สายประสิทธิ์ศาสตร์</small>
    </div>
    <div class="card-body p-4">
        
        <?php if($error): ?>
            <div class="alert alert-danger text-center shadow-sm"><i class="fas fa-times-circle"></i> <?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if($success): ?>
            <div class="alert alert-success text-center shadow-sm">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>

        <?php if($step == 1 && empty($success)): ?>
        <form method="POST">
            <div class="text-center mb-4">
                <img src="uploads/logo.png" width="60" class="mb-2">
                <p class="text-muted">กรุณากรอกข้อมูลเพื่อยืนยันตัวตน</p>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">ชื่อผู้ใช้ (Username)</label>
                <div class="input-group">
                    <span class="input-group-text bg-white"><i class="fas fa-user text-muted"></i></span>
                    <input type="text" name="username" class="form-control" placeholder="เช่น เลขบัตรประชาชน" required autofocus>
                </div>
            </div>

            <div class="mb-4">
                <label class="form-label fw-bold">อีเมลโรงเรียน (หรืออีเมลที่ลงทะเบียน)</label>
                <div class="input-group">
                    <span class="input-group-text bg-white"><i class="fas fa-envelope text-muted"></i></span>
                    <input type="email" name="email" class="form-control" placeholder="example@maesai.ac.th" required>
                </div>
            </div>

            <div class="d-grid gap-2">
                <button type="submit" name="btnVerify" class="btn btn-success fw-bold py-2 shadow-sm">
                    ตรวจสอบข้อมูล
                </button>
                <a href="login.php" class="btn btn-light text-secondary">ยกเลิก / กลับไปหน้าล็อกอิน</a>
            </div>
        </form>

        <?php elseif($step == 2 && empty($success)): ?>
        <form method="POST">
            <input type="hidden" name="user_id" value="<?php echo $verify_id; ?>">
            
            <div class="text-center mb-4">
                <div class="badge bg-success fs-6 mb-2">ยืนยันตัวตนสำเร็จ</div>
                <h5 class="fw-bold text-dark">สวัสดีคุณ <?php echo $verify_name; ?></h5>
                <p class="text-muted small">กรุณาตั้งรหัสผ่านใหม่ของคุณ</p>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold">รหัสผ่านใหม่</label>
                <input type="password" name="new_pass" class="form-control" placeholder="ต้องมีอย่างน้อย 4 ตัวอักษร" required minlength="4">
            </div>

            <div class="mb-4">
                <label class="form-label fw-bold">ยืนยันรหัสผ่านใหม่</label>
                <input type="password" name="confirm_pass" class="form-control" placeholder="กรอกรหัสเดิมอีกครั้ง" required>
            </div>

            <div class="d-grid">
                <button type="submit" name="btnReset" class="btn btn-primary fw-bold py-2 shadow-sm">
                    <i class="fas fa-save"></i> บันทึกรหัสผ่านใหม่
                </button>
            </div>
        </form>
        <?php endif; ?>

    </div>
</div>

</body>
</html>