<?php 
require_once 'auth.php';
require_once 'db.php'; 
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>ทำเนียบอดีตบุคลากร</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container bg-white p-4 rounded shadow-sm">
    <div class="d-flex justify-content-between mb-3">
        <h3 class="text-secondary"><i class="fas fa-user-times"></i> ข้อมูลสถานะไม่มาสอน/พ้นสภาพ</h3>
        <a href="personnel.php" class="btn btn-outline-primary">กลับไปรายชื่อปัจจุบัน</a>
    </div>

    <div class="alert alert-warning">
        หน้านี้แสดงรายชื่อบุคลากรที่ <strong>ลาออก, ย้าย, หรือ เกษียณอายุ</strong> ไปแล้ว
    </div>

    <table id="inactiveTable" class="table table-hover">
        <thead class="table-light">
            <tr>
                <th>รหัส</th>
                <th>ชื่อ-นามสกุล</th>
                <th>ตำแหน่งสุดท้าย</th>
                <th>วันที่พ้นสภาพ</th>
                <th>สาเหตุ/สถานะ</th>
                <th>หมายเหตุ</th>
                <th>จัดการ</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // ดึงเฉพาะคนที่ไม่ใช่สถานะ 'ปกติ' หรือ 'ช่วยราชการ'
            $sql = "SELECT * FROM personnel WHERE status IN ('ลาออก', 'ย้าย', 'เกษียณ') ORDER BY start_date DESC";
            $stmt = $conn->query($sql);
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $statusClass = match($row['status']) {
                    'ลาออก' => 'danger',
                    'ย้าย' => 'info',
                    'เกษียณ' => 'warning',
                    default => 'secondary'
                };
                
                echo "<tr>";
                echo "<td>{$row['code']}</td>";
                echo "<td>{$row['prefix']}{$row['firstname']} {$row['lastname']}</td>";
                echo "<td>{$row['position_type']}</td>";
                echo "<td>".DateThai($row['start_date'])."</td>"; // สมมติใช้วันที่แก้ไขล่าสุดเป็นวันออก
                echo "<td><span class='badge bg-{$statusClass}'>{$row['status']}</span></td>";
                echo "<td>-</td>";
                echo "<td>
                        <a href='profile.php?id={$row['id']}' class='btn btn-sm btn-outline-secondary'>ดูประวัติเก่า</a>
                      </td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#inactiveTable').DataTable();
    });
</script>
</body>
</html>