<?php
session_start();
require_once 'db.php';

// ถ้าล็อกอินอยู่แล้ว ให้เด้งไปหน้าหลัก
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    if (empty($username) || empty($password)) {
        $error = "กรุณากรอกชื่อผู้ใช้และรหัสผ่าน";
    } else {
        try {
            // ดึงข้อมูล User และเชื่อมกับ Personnel
            $stmt = $conn->prepare("
                SELECT u.*, p.firstname, p.lastname, p.image, p.status 
                FROM users u 
                LEFT JOIN personnel p ON u.personnel_id = p.id 
                WHERE u.username = ?
            ");
            $stmt->execute([$username]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                // --- [ส่วนที่แก้ไข] ตรวจสอบรหัสผ่าน 2 ระบบ (Hash และ MD5) ---
                $is_password_correct = false;

                // 1. ตรวจสอบแบบมาตรฐานใหม่ (BCRYPT)
                if (password_verify($password, $user['password'])) {
                    $is_password_correct = true;
                } 
                // 2. ตรวจสอบแบบเก่า (MD5) สำหรับบัญชีเดิม
                elseif (md5($password) === $user['password']) {
                    $is_password_correct = true;
                }

                if ($is_password_correct) {
                    // --- [ส่วนที่แก้ไข] ป้องกัน Error กรณี Admin ไม่มีข้อมูล Personnel ---
                    // ถ้า status เป็นค่าว่าง (NULL) ให้ถือว่าปกติ
                    $status = isset($user['status']) ? $user['status'] : 'ปกติ';

                    if ($status == 'ลาออก') {
                        $error = "บัญชีนี้ถูกระงับการใช้งานเนื่องจากสถานะ: ลาออก";
                    } else {
                        // ล็อกอินสำเร็จ
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['username'] = $user['username'];
                        $_SESSION['role'] = $user['role'];
                        $_SESSION['personnel_id'] = $user['personnel_id'];
                        
                        // ถ้าไม่มีชื่อจริง (เช่น admin) ให้ใช้ username แทน
                        $_SESSION['fullname'] = !empty($user['firstname']) ? $user['firstname'] . ' ' . $user['lastname'] : $user['username'];
                        $_SESSION['user_image'] = !empty($user['image']) ? $user['image'] : 'default.png';

                        header("Location: index.php");
                        exit;
                    }
                } else {
                    $error = "รหัสผ่านไม่ถูกต้อง";
                }
            } else {
                $error = "ไม่พบชื่อผู้ใช้นี้ในระบบ";
            }
        } catch (PDOException $e) {
            $error = "เกิดข้อผิดพลาด: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>เข้าสู่ระบบ - HR Maesai</title>
    <link rel="icon" type="image/png" href="uploads/logo.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #e8f5e9;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            max-width: 400px;
            width: 100%;
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .login-header {
            background: linear-gradient(135deg, #198754 0%, #157347 100%);
            padding: 30px;
            text-align: center;
            color: white;
        }
        .logo-img {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            padding: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.2);
        }
        .btn-login {
            background: #198754;
            border: none;
            padding: 12px;
            font-size: 1.1rem;
            font-weight: bold;
            transition: 0.3s;
        }
        .btn-login:hover {
            background: #146c43;
            transform: translateY(-2px);
        }
        .form-control:focus {
            border-color: #198754;
            box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
        }
    </style>
</head>
<body>

<div class="login-card card">
    <div class="login-header">
        <img src="uploads/logo.png" alt="Logo" class="logo-img">
        <h4 class="fw-bold mb-0">ระบบบริหารงานบุคคล</h4>
        <small>โรงเรียนแม่สายประสิทธิ์ศาสตร์</small>
    </div>
    <div class="card-body p-4">
        
        <?php if ($error): ?>
            <div class="alert alert-danger text-center py-2 mb-3">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3">
                <label class="form-label fw-bold text-secondary">ชื่อผู้ใช้ (Username)</label>
                <div class="input-group">
                    <span class="input-group-text bg-light"><i class="fas fa-user text-success"></i></span>
                    <input type="text" name="username" class="form-control" placeholder="ระบุชื่อผู้ใช้" required autofocus>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold text-secondary">รหัสผ่าน (Password)</label>
                <div class="input-group">
                    <span class="input-group-text bg-light"><i class="fas fa-lock text-success"></i></span>
                    <input type="password" name="password" class="form-control" placeholder="ระบุรหัสผ่าน" required>
                </div>
            </div>

            <div class="d-flex justify-content-end mb-4">
                <a href="forgot_password.php" class="text-decoration-none text-muted small">
                    <i class="fas fa-key"></i> ลืมรหัสผ่าน?
                </a>
            </div>

            <div class="d-grid">
                <button type="submit" class="btn btn-primary btn-login text-white shadow-sm">
                    <i class="fas fa-sign-in-alt me-2"></i> เข้าสู่ระบบ
                </button>
            </div>
        </form>
    </div>
    <div class="card-footer bg-light text-center py-3 text-muted small">
        &copy; <?php echo date("Y"); ?> HR Maesai System v1.0
    </div>
</div>

</body>
</html>