<nav class="navbar navbar-expand-lg navbar-dark bg-success shadow-sm mb-4">
    <div class="container">
        <a class="navbar-brand fw-bold d-flex align-items-center" href="index.php">
            <img src="uploads/logo.png" alt="HR Maesai" width="45" height="auto" class="d-inline-block align-text-top me-2 filter-white">
            HR Maesai
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link" href="index.php"><i class="fas fa-home"></i> หน้าหลัก</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="personnel.php"><i class="fas fa-users"></i> บุคลากร</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="attendance.php"><i class="fas fa-clock"></i> ลงเวลา</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="leaves.php"><i class="fas fa-file-medical"></i> การลา</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="official_travel.php"><i class="fas fa-car-side"></i> ไปราชการ</a>
                </li>

                <?php if(isAdmin()): ?>
                
                <li class="nav-item">
                    <a class="nav-link" href="add_user.php">
                        <i class="fas fa-user-plus"></i> เพิ่มผู้ใช้งาน
                    </a>
                </li>
                
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-warning fw-bold" href="#" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-file-export"></i> รวมรายงาน
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="reports.php">
                                <i class="fas fa-chart-line me-2"></i> ภาพรวมรายงาน
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="export.php?act=excel">
                                <i class="fas fa-file-excel text-success me-2"></i> ส่งออกข้อมูล (Excel)
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="print_list.php" target="_blank">
                                <i class="fas fa-print text-dark me-2"></i> พิมพ์ทำเนียบบุคลากร
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="retirement.php">
                                <i class="fas fa-user-clock me-2"></i> รายงานผู้เกษียณอายุ
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="trash.php">
                                <i class="fas fa-trash-alt me-2"></i> ถังขยะ (กู้คืนข้อมูล)
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>

            <ul class="navbar-nav ms-auto">
                <?php if(isset($_SESSION['username'])): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle active" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle"></i> คุณ<?php echo $_SESSION['username']; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow">
                            
                            <?php if(!isAdmin()): ?>
                                <li>
                                    <a class="dropdown-item" href="profile.php">
                                        <i class="fas fa-address-card text-primary me-2"></i> ข้อมูลส่วนตัว
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="personnel_edit.php">
                                        <i class="fas fa-user-edit text-warning me-2"></i> แก้ไขประวัติส่วนตัว
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                            <?php endif; ?>
                            
                            <li>
                                <a class="dropdown-item" href="change_password.php">
                                    <i class="fas fa-key text-info me-2"></i> เปลี่ยนรหัสผ่าน
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item text-danger" href="logout.php">
                                    <i class="fas fa-sign-out-alt me-2"></i> ออกจากระบบ
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php">เข้าสู่ระบบ</a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<style>
    .navbar-brand img {
        background-color: white;
        border-radius: 50%;
        padding: 2px;
        box-shadow: 0 0 5px rgba(0,0,0,0.2);
    }
</style>