<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

$is_admin = isAdmin(); 
$my_id = $_SESSION['personnel_id'];

// --- ส่วนจัดการข้อมูล (PHP) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (isset($_POST['btnSave'])) {
            // [เพิ่มข้อมูล]
            $pid = ($is_admin && !empty($_POST['personnel_id'])) ? $_POST['personnel_id'] : $my_id;
            
            $stmt = $conn->prepare("INSERT INTO official_travel (personnel_id, doc_no, doc_date, type, topic, start_date, end_date, location, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'รออนุมัติ')");
            $stmt->execute([
                $pid, $_POST['doc_no'], $_POST['doc_date'], 
                $_POST['type'], $_POST['topic'], $_POST['start_date'], 
                $_POST['end_date'], $_POST['location']
            ]);
            $msg = "บันทึกข้อมูลเรียบร้อย";
            echo "<script>alert('$msg'); window.location='official_travel.php';</script>";

        } elseif (isset($_POST['btnUpdate'])) {
            // [แก้ไข/อนุมัติ]
            if(!$is_admin) {
                 // User แก้ไข: บังคับ ID เดิม และสถานะต้องเป็น 'รออนุมัติ' เท่านั้น
                 $stmt = $conn->prepare("UPDATE official_travel SET doc_no=?, doc_date=?, type=?, topic=?, start_date=?, end_date=?, location=? WHERE id=? AND personnel_id=?");
                 $stmt->execute([
                    $_POST['doc_no'], $_POST['doc_date'], 
                    $_POST['type'], $_POST['topic'], $_POST['start_date'], 
                    $_POST['end_date'], $_POST['location'], $_POST['id'], $my_id
                ]);
            } else {
                // Admin แก้ไข: แก้ได้ทุกช่องรวมถึงสถานะ
                $stmt = $conn->prepare("UPDATE official_travel SET personnel_id=?, doc_no=?, doc_date=?, type=?, topic=?, start_date=?, end_date=?, location=?, status=? WHERE id=?");
                $stmt->execute([
                    $_POST['personnel_id'], $_POST['doc_no'], $_POST['doc_date'], 
                    $_POST['type'], $_POST['topic'], $_POST['start_date'], 
                    $_POST['end_date'], $_POST['location'], $_POST['status'], $_POST['id']
                ]);
            }
            
            $msg = "อัปเดตข้อมูลเรียบร้อย";
            echo "<script>alert('$msg'); window.location='official_travel.php';</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Error: " . $e->getMessage() . "');</script>";
    }
}

// --- ส่วนลบข้อมูล ---
if (isset($_GET['delete_id'])) {
    $del_id = $_GET['delete_id'];
    if(!$is_admin) {
        $chk = $conn->prepare("SELECT status FROM official_travel WHERE id=? AND personnel_id=?");
        $chk->execute([$del_id, $my_id]);
        $row = $chk->fetch();
        if(!$row || $row['status'] != 'รออนุมัติ') {
            echo "<script>alert('ลบได้เฉพาะสถานะรออนุมัติเท่านั้น'); window.location='official_travel.php';</script>";
            exit;
        }
    }
    
    $conn->prepare("DELETE FROM official_travel WHERE id=?")->execute([$del_id]);
    echo "<script>alert('ลบข้อมูลเรียบร้อย'); window.location='official_travel.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <title>บันทึกการไปราชการ</title>
    <link rel="icon" type="image/png" href="uploads/logo.png">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Sarabun', sans-serif; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container p-3 p-md-4 bg-white rounded shadow-sm mt-3 mb-5">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 gap-2">
        <div>
            <h3 class="mb-0 text-success fw-bold"><i class="fas fa-car-side"></i> ข้อมูลการไปราชการ</h3>
            <small class="text-muted">
                <?php echo $is_admin ? "จัดการคำสั่งไปราชการทั้งหมด" : "ประวัติการไปราชการของคุณ"; ?>
            </small>
        </div>
        <button type="button" class="btn btn-success w-100 w-md-auto shadow-sm" onclick="openModal('add')">
            <i class="fas fa-plus"></i> เพิ่มรายการใหม่
        </button>
    </div>

    <div class="table-responsive">
        <table id="travelTable" class="table table-bordered table-hover align-middle w-100 text-nowrap">
            <thead class="table-success">
                <tr>
                    <th>วันที่ไป</th>
                    <th>เลขที่คำสั่ง</th>
                    <?php if($is_admin) echo "<th>ชื่อ-นามสกุล</th>"; ?>
                    <th>เรื่อง</th>
                    <th>สถานที่</th>
                    <th>สถานะ</th>
                    <th>จัดการ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Query ข้อมูล
                $sql = "SELECT t.*, p.firstname, p.lastname, p.prefix 
                        FROM official_travel t 
                        LEFT JOIN personnel p ON t.personnel_id = p.id ";
                
                if(!$is_admin) {
                    $sql .= " WHERE t.personnel_id = $my_id ";
                }
                
                $sql .= " ORDER BY t.start_date DESC";
                
                $stmt = $conn->query($sql);
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)):
                    // เตรียมข้อมูล JSON สำหรับปุ่มแก้ไข
                    $json_data = htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8');
                    
                    $st_color = 'secondary';
                    if($row['status']=='อนุมัติ') $st_color = 'success';
                    if($row['status']=='ไม่อนุมัติ') $st_color = 'danger';
                    if($row['status']=='รออนุมัติ') $st_color = 'warning text-dark';
                ?>
                <tr>
                    <td>
                        <small><?php echo date('d/m/Y', strtotime($row['start_date'])); ?></small>
                        <br>
                        <small class="text-muted">ถึง <?php echo date('d/m/Y', strtotime($row['end_date'])); ?></small>
                    </td>
                    <td><?php echo $row['doc_no']; ?></td>
                    <?php if($is_admin): ?>
                        <td><?php echo $row['prefix'].$row['firstname'].' '.$row['lastname']; ?></td>
                    <?php endif; ?>
                    <td><?php echo $row['topic']; ?></td>
                    <td><?php echo $row['location']; ?></td>
                    <td><span class="badge bg-<?php echo $st_color; ?>"><?php echo $row['status']; ?></span></td>
                    <td>
                        <button class="btn btn-warning btn-sm" onclick="openModal('edit', <?php echo $json_data; ?>)">
                            <i class="fas fa-edit"></i>
                        </button>
                        
                        <?php if($is_admin || $row['status'] == 'รออนุมัติ'): ?>
                        <a href="official_travel.php?delete_id=<?php echo $row['id']; ?>" 
                           class="btn btn-danger btn-sm"
                           onclick="return confirm('ยืนยันการลบข้อมูลนี้?');">
                           <i class="fas fa-trash"></i>
                        </a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="travelModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title fw-bold" id="modalTitle"><i class="fas fa-plus-circle"></i> เพิ่มรายการไปราชการ</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id" id="data_id">
                    
                    <?php if($is_admin): ?>
                    <div class="mb-3">
                        <label class="form-label fw-bold">บุคลากร</label>
                        <select name="personnel_id" id="personnel_id" class="form-select" required>
                            <option value="">-- เลือกบุคลากร --</option>
                            <?php 
                            $p_stmt = $conn->query("SELECT id, prefix, firstname, lastname FROM personnel WHERE status='ปกติ' ORDER BY firstname");
                            while($p = $p_stmt->fetch()) {
                                echo "<option value='{$p['id']}'>{$p['prefix']}{$p['firstname']} {$p['lastname']}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <?php endif; ?>

                    <div class="row g-2">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">เลขที่คำสั่ง/หนังสือ</label>
                            <input type="text" name="doc_no" id="doc_no" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">ลงวันที่</label>
                            <input type="date" name="doc_date" id="doc_date" class="form-control" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">เรื่อง / หัวข้อการไปราชการ</label>
                        <input type="text" name="topic" id="topic" class="form-control" required>
                    </div>

                    <div class="row g-2">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">ประเภท</label>
                            <select name="type" id="type" class="form-select">
                                <option value="อบรม/สัมมนา">อบรม/สัมมนา</option>
                                <option value="ศึกษาดูงาน">ศึกษาดูงาน</option>
                                <option value="ประชุม">ประชุม</option>
                                <option value="พานักเรียนไปแข่งทักษะ">พานักเรียนไปแข่งทักษะ</option>
                                <option value="อื่นๆ">อื่นๆ</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">สถานที่</label>
                            <input type="text" name="location" id="location" class="form-control" required>
                        </div>
                    </div>

                    <div class="row g-2">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">วันที่เริ่ม</label>
                            <input type="date" name="start_date" id="start_date" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">ถึงวันที่</label>
                            <input type="date" name="end_date" id="end_date" class="form-control" required>
                        </div>
                    </div>

                    <?php if($is_admin): ?>
                    <div class="mb-3 p-3 bg-light rounded border">
                        <label class="form-label fw-bold text-danger">สถานะ (สำหรับผู้ดูแลระบบ)</label>
                        <div class="d-flex gap-3">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status_wait" value="รออนุมัติ" checked>
                                <label class="form-check-label" for="status_wait">รออนุมัติ</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status_approve" value="อนุมัติ">
                                <label class="form-check-label text-success" for="status_approve">อนุมัติ</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status_reject" value="ไม่อนุมัติ">
                                <label class="form-check-label text-danger" for="status_reject">ไม่อนุมัติ</label>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                        <input type="hidden" name="status" id="status_hidden" value="รออนุมัติ">
                    <?php endif; ?>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                    <button type="submit" name="btnSave" id="btnSubmit" class="btn btn-success fw-bold">บันทึกข้อมูล</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function() {
        $('#travelTable').DataTable({
            "language": { "url": "//cdn.datatables.net/plug-ins/1.13.4/i18n/th.json" }
        });
    });

    // ฟังก์ชันเปิด Modal
    function openModal(mode, data = null) {
        // เรียกใช้ Bootstrap Modal (ตัวแปร bootstrap มาจาก footer.php)
        var modal = new bootstrap.Modal(document.getElementById('travelModal'));
        
        if (mode === 'add') {
            document.getElementById('modalTitle').innerHTML = '<i class="fas fa-plus-circle"></i> เพิ่มรายการใหม่';
            document.getElementById('btnSubmit').name = 'btnSave';
            document.getElementById('btnSubmit').innerText = 'บันทึกข้อมูล';
            document.getElementById('btnSubmit').className = 'btn btn-success fw-bold';
            
            // เคลียร์ค่า
            document.querySelector('form').reset();
            document.getElementById('data_id').value = '';
            
        } else {
            document.getElementById('modalTitle').innerHTML = '<i class="fas fa-edit"></i> แก้ไขข้อมูล';
            document.getElementById('btnSubmit').name = 'btnUpdate';
            document.getElementById('btnSubmit').innerText = 'อัปเดตข้อมูล';
            document.getElementById('btnSubmit').className = 'btn btn-warning fw-bold text-dark';
            
            // ใส่ค่าเดิม
            document.getElementById('data_id').value = data.id;
            document.getElementById('doc_no').value = data.doc_no;
            document.getElementById('doc_date').value = data.doc_date;
            document.getElementById('topic').value = data.topic;
            document.getElementById('type').value = data.type;
            document.getElementById('location').value = data.location;
            document.getElementById('start_date').value = data.start_date;
            document.getElementById('end_date').value = data.end_date;
            
            if(document.getElementById('personnel_id')) {
                document.getElementById('personnel_id').value = data.personnel_id;
                if(data.status == 'รออนุมัติ') document.getElementById('status_wait').checked = true;
                if(data.status == 'อนุมัติ') document.getElementById('status_approve').checked = true;
                if(data.status == 'ไม่อนุมัติ') document.getElementById('status_reject').checked = true;
            }
        }
        
        modal.show();
    }
</script>

</body>
</html>