<?php
ob_start();
require_once 'auth.php';
require_once 'db.php';

// 1. เช็กสิทธิ์ Admin
if (!isAdmin()) {
    echo "<script>alert('คุณไม่มีสิทธิ์ใช้งานหน้านี้'); window.location='index.php';</script>";
    exit;
}

// 2. รับค่า ID
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    try {
        // (Optional) ลบรูปภาพออกจาก Server
        $stmt_img = $conn->prepare("SELECT image FROM personnel WHERE id = ?");
        $stmt_img->execute([$id]);
        $img = $stmt_img->fetchColumn();
        
        if ($img && $img != 'default.png' && file_exists("uploads/$img")) { 
            @unlink("uploads/$img");
        }

        // 3. ลบข้อมูลในตารางที่เกี่ยวข้อง (Foreign Keys) ให้หมด
        $conn->prepare("DELETE FROM users WHERE personnel_id = ?")->execute([$id]); // ลบ User Login
        $conn->prepare("DELETE FROM personnel_education WHERE personnel_id = ?")->execute([$id]);
        $conn->prepare("DELETE FROM attendance WHERE personnel_id = ?")->execute([$id]);
        $conn->prepare("DELETE FROM leaves WHERE personnel_id = ?")->execute([$id]);

        // 4. ลบข้อมูลหลักในตาราง personnel (ลบจริงๆ แล้วนะ)
        $stmt = $conn->prepare("DELETE FROM personnel WHERE id = ?");
        
        if ($stmt->execute([$id])) {
            echo "<script>
                alert('ลบข้อมูลถาวรเรียบร้อยแล้ว (ไม่สามารถกู้คืนได้)');
                window.location = 'trash.php';
            </script>";
        } else {
            echo "<script>alert('เกิดข้อผิดพลาดในการลบ'); window.location='trash.php';</script>";
        }

    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    header("location: trash.php");
}
ob_end_flush();
?>