<?php
require_once 'auth.php';
require_once 'db.php';
$id = $_GET['id']; // รับ ID ของการลา (leave_id)

// ดึงข้อมูลการลา + ข้อมูลคน
$sql = "SELECT l.*, p.firstname, p.lastname, p.position_type, p.department 
        FROM leaves l 
        JOIN personnel p ON l.personnel_id = p.id 
        WHERE l.id = ?";
$stmt = $conn->prepare($sql);
$stmt->execute([$id]);
$leave = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>แบบใบลาป่วย/ลากิจ/ลาพักผ่อน</title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Sarabun', sans-serif; padding: 40px; }
        .page { width: 210mm; margin: auto; }
        .header { text-align: center; font-weight: bold; margin-bottom: 30px; }
        .content { line-height: 2; font-size: 16px; }
        .sign-area { margin-top: 50px; text-align: right; }
        @media print { 
            .no-print { display: none; } 
            body { padding: 0; }
        }
    </style>
</head>
<body>

<div class="text-center no-print mb-4">
    <button onclick="window.print()" class="btn btn-primary">สั่งพิมพ์ใบลา</button>
</div>

<div class="page">
    <div class="header">
        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Emblem_of_the_Ministry_of_Education_of_Thailand.svg/1200px-Emblem_of_the_Ministry_of_Education_of_Thailand.svg.png" width="50"><br>
        แบบใบลาป่วย ลากิจส่วนตัว ลาพักผ่อน
    </div>
    
    <div style="text-align: right;">
        เขียนที่ โรงเรียนแม่สายประสิทธิ์ศาสตร์<br>
        วันที่ <?php echo DateThai(date('Y-m-d')); ?>
    </div>

    <div class="content mt-4">
        <p>
            <strong>เรื่อง</strong> ขอ<?php echo $leave['leave_type']; ?><br>
            <strong>เรียน</strong> ผู้อำนวยการโรงเรียนแม่สายประสิทธิ์ศาสตร์
        </p>
        <p style="text-indent: 50px;">
            ข้าพเจ้า <strong><?php echo $leave['firstname'].' '.$leave['lastname']; ?></strong> 
            ตำแหน่ง <strong><?php echo $leave['position_type']; ?></strong>
            สังกัด <strong><?php echo $leave['department']; ?></strong>
        </p>
        <p style="text-indent: 50px;">
            ขอ<?php echo $leave['leave_type']; ?> เนื่องจาก <u><?php echo $leave['reason']; ?></u>
            ตั้งแต่วันที่ <strong><?php echo DateThai($leave['start_date']); ?></strong> 
            ถึงวันที่ <strong><?php echo DateThai($leave['end_date']); ?></strong>
            มีกำหนด <?php echo (date_diff(date_create($leave['start_date']), date_create($leave['end_date']))->format("%a")+1); ?> วัน
        </p>
        
        <div class="sign-area">
            <p>ลงชื่อ ...........................................................</p>
            <p>( <?php echo $leave['firstname'].' '.$leave['lastname']; ?> )</p>
            <p>ตำแหน่ง <?php echo $leave['position_type']; ?></p>
        </div>

        <div style="margin-top: 50px;">
            <strong>ความเห็นผู้อำนวยการสถานศึกษา</strong><br>
            [ &nbsp; ] อนุญาต <br>
            [ &nbsp; ] ไม่อนุญาต .................................................
            <br><br><br>
            ลงชื่อ ...........................................................<br>
            ( ........................................................... )<br>
            ตำแหน่ง ผู้อำนวยการโรงเรียนแม่สายประสิทธิ์ศาสตร์
        </div>
    </div>
</div>

</body>
</html>