<?php
require_once 'auth.php';
require_once 'db.php';

// รับค่า Filter
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';

// ตั้งค่าหัวข้อรายงานตาม Filter
$report_title = "รายชื่อบุคลากร";
if($filter == 'retire') $report_title = "รายชื่อผู้เกษียณอายุราชการ";
if($filter == 'birthday') $report_title = "รายชื่อบุคลากรที่เกิดเดือนนี้ (" . date('M') . ")";
if($filter == 'dept') $report_title = "รายชื่อแยกตามกลุ่มสาระฯ";

// หมวดหมู่ตำแหน่งปกติ
$all_categories = [
    'exec' => ['name' => 'ผู้บริหาร', 'positions' => ['ผู้อำนวยการ', 'รองผู้อำนวยการ']],
    'teacher' => ['name' => 'ข้าราชการครู', 'positions' => ['ครู', 'ครูผู้ช่วย']],
    'gov_emp' => ['name' => 'พนักงานราชการ', 'positions' => ['พนักงานราชการ']],
    'emp' => ['name' => 'ลูกจ้างและบุคลากรอื่นๆ', 'positions' => ['อัตราจ้าง', 'ครูอัตราจ้าง', 'ลูกจ้างประจำ', 'ลูกจ้างชั่วคราว', 'จ้างเหมาบริการ', 'เจ้าหน้าที่', 'ธุรการ', 'นักการภารโรง']]
];
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title><?php echo $report_title; ?> - โรงเรียนแม่สายประสิทธิ์ศาสตร์</title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Sarabun', sans-serif; padding: 20px; }
        h2 { text-align: center; margin-bottom: 5px; }
        h4 { text-align: center; margin-top: 0; margin-bottom: 20px; color: #555; }
        .header-info { text-align: right; font-size: 12px; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #333; padding: 8px; text-align: left; font-size: 14px; }
        th { background-color: #f0f0f0; text-align: center; font-weight: bold; }
        .text-center { text-align: center; }
        .group-header { background-color: #e0e0e0; font-weight: bold; padding: 10px; }
        .no-print { text-align: center; margin-bottom: 20px; }
        .btn { background-color: #198754; color: white; padding: 10px 20px; border: none; cursor: pointer; text-decoration: none; border-radius: 5px; font-size: 14px; }
        .btn-back { background-color: #6c757d; margin-left: 10px; }
        @media print { .no-print { display: none; } @page { margin: 1cm; size: A4 portrait; } }
    </style>
</head>
<body>

    <div class="no-print">
        <button onclick="window.print()" class="btn">🖨️ สั่งพิมพ์รายงาน</button>
        <a href="reports.php" class="btn btn-back">🔙 กลับหน้ารายงาน</a>
    </div>

    <h2><?php echo $report_title; ?></h2>
    <h4>โรงเรียนแม่สายประสิทธิ์ศาสตร์</h4>
    <div class="header-info">ข้อมูล ณ วันที่ <?php echo date("d/m/Y"); ?></div>

    <?php 
    // ==========================================
    // CASE 1: รายงานวันเกิด (Birthday)
    // ==========================================
    if ($filter == 'birthday'):
        $current_month = date('m');
        // เรียงตามวันที่เกิด (วัน 1-31)
        $sql = "SELECT *, DAY(birthdate) as d FROM personnel 
                WHERE status='ปกติ' AND is_deleted=0 AND MONTH(birthdate) = ? 
                ORDER BY DAY(birthdate) ASC";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$current_month]);
        $list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>
        <?php if(count($list) > 0): ?>
        <table>
            <thead>
                <tr class="group-header"><td colspan="5">เกิดเดือนนี้ (<?php echo count($list); ?> คน)</td></tr>
                <tr><th width="5%">ลำดับ</th><th width="30%">ชื่อ-นามสกุล</th><th width="20%">วันเกิด</th><th width="20%">ตำแหน่ง</th><th width="25%">เบอร์โทร</th></tr>
            </thead>
            <tbody>
                <?php $i=1; foreach ($list as $row): 
                    $bdate = date('d/m', strtotime($row['birthdate'])) . "/" . (date('Y', strtotime($row['birthdate']))+543);
                ?>
                <tr>
                    <td class="text-center"><?php echo $i++; ?></td>
                    <td><?php echo $row['prefix'] . $row['firstname'] . ' ' . $row['lastname']; ?></td>
                    <td class="text-center fw-bold text-success"><?php echo $bdate; ?></td>
                    <td class="text-center"><?php echo $row['position_type']; ?></td>
                    <td class="text-center"><?php echo $row['phone']; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
            <div style="text-align:center; padding:20px; color:#666;">-- ไม่มีบุคลากรเกิดในเดือนนี้ --</div>
        <?php endif; ?>

    <?php 
    // ==========================================
    // CASE 2: รายงานผู้เกษียณ (Retire)
    // ==========================================
    elseif ($filter == 'retire'):
        $retire_target = (date('Y') - 60) . "-10-01";
        $sql = "SELECT * FROM personnel WHERE status='ปกติ' AND is_deleted=0 AND birthdate <= ? ORDER BY birthdate ASC";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$retire_target]);
        $list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>
        <?php if(count($list) > 0): ?>
        <table>
            <thead>
                <tr class="group-header"><td colspan="6">ผู้ครบวาระเกษียณอายุ (<?php echo count($list); ?> คน)</td></tr>
                <tr><th width="5%">ลำดับ</th><th width="25%">ชื่อ-นามสกุล</th><th width="15%">วันเกิด</th><th width="10%">อายุ</th><th width="20%">ตำแหน่ง</th><th width="25%">หมายเหตุ</th></tr>
            </thead>
            <tbody>
                <?php $i=1; foreach ($list as $row): 
                    $age = date('Y') - date('Y', strtotime($row['birthdate']));
                    $bdate = date('d/m/Y', strtotime($row['birthdate']));
                ?>
                <tr>
                    <td class="text-center"><?php echo $i++; ?></td>
                    <td><?php echo $row['prefix'] . $row['firstname'] . ' ' . $row['lastname']; ?></td>
                    <td class="text-center"><?php echo $bdate; ?></td>
                    <td class="text-center"><?php echo $age; ?> ปี</td>
                    <td class="text-center"><?php echo $row['position_type']; ?></td>
                    <td></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
            <div style="text-align:center; padding:20px; color:#666;">-- ไม่พบรายชื่อผู้เกษียณอายุ --</div>
        <?php endif; ?>

    <?php 
    // ==========================================
    // CASE 3: แยกตามกลุ่มสาระฯ (Department)
    // ==========================================
    elseif ($filter == 'dept'):
        $dept_stmt = $conn->query("SELECT DISTINCT department FROM personnel WHERE status='ปกติ' AND is_deleted=0 AND department!='' ORDER BY department");
        while($dept = $dept_stmt->fetch(PDO::FETCH_ASSOC)):
            $d_name = $dept['department'];
            $sql = "SELECT * FROM personnel WHERE status='ปกติ' AND is_deleted=0 AND department = ? ORDER BY firstname ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([$d_name]);
            $list = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if(count($list) == 0) continue;
    ?>
        <table>
            <thead>
                <tr class="group-header"><td colspan="5">กลุ่มสาระฯ: <?php echo $d_name; ?> (<?php echo count($list); ?> คน)</td></tr>
                <tr><th width="5%">ลำดับ</th><th width="30%">ชื่อ-นามสกุล</th><th width="20%">ตำแหน่ง</th><th width="20%">เบอร์โทร</th><th width="25%">หมายเหตุ</th></tr>
            </thead>
            <tbody>
                <?php $i=1; foreach ($list as $row): ?>
                <tr>
                    <td class="text-center"><?php echo $i++; ?></td>
                    <td><?php echo $row['prefix'] . $row['firstname'] . ' ' . $row['lastname']; ?></td>
                    <td class="text-center"><?php echo $row['position_type']; ?></td>
                    <td class="text-center"><?php echo $row['phone']; ?></td>
                    <td></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endwhile; ?>

    <?php 
    // ==========================================
    // CASE 4: รายงานปกติ (แยกตามตำแหน่ง)
    // ==========================================
    else:
        // กรองหมวดหมู่ที่จะแสดง
        $categories_to_show = [];
        if ($filter == 'all') {
            $categories_to_show = $all_categories;
        } elseif (array_key_exists($filter, $all_categories)) {
            $categories_to_show[$filter] = $all_categories[$filter];
        }

        foreach ($categories_to_show as $key => $cat): 
            $positions = $cat['positions'];
            $placeholders = implode(',', array_fill(0, count($positions), '?'));
            $sql = "SELECT * FROM personnel WHERE status = 'ปกติ' AND is_deleted = 0 AND position_type IN ($placeholders) ORDER BY firstname ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute($positions);
            $personnel_list = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($personnel_list) == 0) continue;
    ?>
        <table>
            <thead>
                <tr class="group-header"><td colspan="5"><?php echo $cat['name']; ?> (<?php echo count($personnel_list); ?> คน)</td></tr>
                <tr><th width="5%">ลำดับ</th><th width="30%">ชื่อ-นามสกุล</th><th width="20%">ตำแหน่ง</th><th width="20%">เบอร์โทร</th><th width="25%">หมายเหตุ</th></tr>
            </thead>
            <tbody>
                <?php $i=1; foreach ($personnel_list as $row): ?>
                <tr>
                    <td class="text-center"><?php echo $i++; ?></td>
                    <td><?php echo $row['prefix'] . $row['firstname'] . ' ' . $row['lastname']; ?></td>
                    <td class="text-center"><?php echo $row['position_type']; ?></td>
                    <td class="text-center"><?php echo $row['phone']; ?></td>
                    <td></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php 
        endforeach; 
    endif;
    ?>

</body>
</html>