<?php
require_once 'auth.php'; require_once 'db.php';
$id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM official_travel WHERE id = ?");
$stmt->execute([$id]);
$travel = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>บันทึกข้อความขอไปราชการ</title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Sarabun', sans-serif; padding: 40px; }
        .page { width: 210mm; margin: auto; }
        .header { text-align: center; font-weight: bold; font-size: 20px; }
        .content { line-height: 2; font-size: 16px; margin-top: 20px; }
        @media print { .no-print { display: none; } body { padding: 0; } }
    </style>
</head>
<body>
    <div class="text-center no-print mb-4">
        <button onclick="window.print()" class="btn btn-primary">พิมพ์บันทึกข้อความ</button>
    </div>
    <div class="page">
        <div class="header">
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Emblem_of_the_Ministry_of_Education_of_Thailand.svg/1200px-Emblem_of_the_Ministry_of_Education_of_Thailand.svg.png" width="60"><br>
            บันทึกข้อความ
        </div>
        <div class="content">
            <p><strong>ส่วนราชการ</strong> โรงเรียนแม่สายประสิทธิ์ศาสตร์</p>
            <p><strong>ที่</strong> <?php echo $travel['doc_no']; ?> <strong>วันที่</strong> <?php echo DateThai($travel['doc_date']); ?></p>
            <p><strong>เรื่อง</strong> ขออนุญาตไปราชการ (<?php echo $travel['topic']; ?>)</p>
            <hr>
            <p><strong>เรียน</strong> ผู้อำนวยการโรงเรียนแม่สายประสิทธิ์ศาสตร์</p>
            <p style="text-indent: 50px;">
                ด้วยข้าพเจ้า มีความประสงค์ขออนุญาตไปราชการเพื่อ <strong><?php echo $travel['type']; ?></strong>
                เรื่อง "<?php echo $travel['topic']; ?>"
                ณ <strong><?php echo $travel['location']; ?></strong>
            </p>
            <p style="text-indent: 50px;">
                ตั้งแต่วันที่ <strong><?php echo DateThai($travel['start_date']); ?></strong> 
                ถึงวันที่ <strong><?php echo DateThai($travel['end_date']); ?></strong>
            </p>
            <p style="text-indent: 50px;">จึงเรียนมาเพื่อโปรดพิจารณา</p>
            
            <div style="margin-top: 50px; text-align: right; padding-right: 50px;">
                <p>ลงชื่อ .......................................................</p>
                <p>( ....................................................... )</p>
                <p>ผู้ขออนุญาต</p>
            </div>
            
            <div style="margin-top: 50px;">
                <strong>ความเห็นผู้อำนวยการ</strong><br>
                [ &nbsp; ] อนุญาต <br>
                [ &nbsp; ] ไม่อนุญาต ..................................................
                <br><br>
                ลงชื่อ .......................................................<br>
                ( ....................................................... )<br>
                ตำแหน่ง ผู้อำนวยการโรงเรียนแม่สายประสิทธิ์ศาสตร์
            </div>
        </div>
    </div>
</body>
</html>