<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

// ตรวจสอบสิทธิ์
$is_admin = isAdmin();
$my_id = $_SESSION['personnel_id'];

// รับค่า ID ที่จะดู
$view_id = isset($_GET['id']) ? $_GET['id'] : $my_id;

// Security: ถ้าไม่ใช่ Admin และพยายามดูคนอื่น -> ให้ดูของตัวเองแทน
if (!$is_admin && $view_id != $my_id) {
    $view_id = $my_id;
}

$user_data = null;
$educations = [];

if ($view_id) {
    // ดึงข้อมูลบุคลากร
    $stmt = $conn->prepare("SELECT * FROM personnel WHERE id = ?");
    $stmt->execute([$view_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);

    // ดึงประวัติการศึกษา
    $stmt_edu = $conn->prepare("SELECT * FROM personnel_education WHERE personnel_id = ? ORDER BY edu_date DESC");
    $stmt_edu->execute([$view_id]);
    $educations = $stmt_edu->fetchAll(PDO::FETCH_ASSOC);
    
    // คำนวณวันเกษียณ (60 ปี)
    $retire_date = "-";
    $age = "-";
    if(!empty($user_data['birthdate'])) {
        $birth_date = new DateTime($user_data['birthdate']);
        $today = new DateTime();
        $age = $today->diff($birth_date)->y; // คำนวณอายุ

        $birth_year = date('Y', strtotime($user_data['birthdate']));
        $retire_year = $birth_year + 60;
        $retire_date = "30 กันยายน " . ($retire_year + 543);
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>โปรไฟล์บุคลากร</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .profile-card { border-radius: 15px; border: none; }
        .profile-img { width: 150px; height: 150px; object-fit: cover; border: 5px solid #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
        .bg-profile { background: linear-gradient(135deg, #006633 0%, #00b359 100%); height: 120px; border-radius: 15px 15px 0 0; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container mt-4 mb-5">
    <div class="mb-3">
        <a href="personnel.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> กลับไปหน้ารายชื่อ</a>
    </div>

    <div class="card profile-card shadow-sm mb-4">
        <div class="bg-profile"></div>
        <div class="card-body text-center" style="margin-top: -75px;">
            <?php if ($user_data): ?>
                <img src="uploads/<?php echo $user_data['image']; ?>" class="rounded-circle profile-img mb-3 bg-white">
                
                <h3 class="fw-bold mb-0">
                    <?php echo $user_data['prefix'].$user_data['firstname']." ".$user_data['lastname']; ?>
                    <?php if(!empty($user_data['nickname'])) echo " <span class='text-muted fs-5'>({$user_data['nickname']})</span>"; ?>
                </h3>
                
                <?php if(!empty($user_data['firstname_en'])): ?>
                    <p class="text-secondary mb-1"><?php echo ucfirst($user_data['firstname_en'])." ".ucfirst($user_data['lastname_en']); ?></p>
                <?php endif; ?>

                <p class="text-success fw-bold"><?php echo $user_data['position_type']; ?></p>
                
                <div class="mt-3">
                    <?php if($is_admin || $view_id == $my_id): ?>
                        <a href="personnel_edit.php?id=<?php echo $view_id; ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i> แก้ไขข้อมูล</a>
                    <?php endif; ?>
                    <a href="print_profile.php?id=<?php echo $view_id; ?>" target="_blank" class="btn btn-dark btn-sm"><i class="fas fa-print"></i> พิมพ์ประวัติ</a>
                </div>
            <?php else: ?>
                <div class="py-4">
                    <i class="fas fa-exclamation-circle fa-3x text-secondary mb-3"></i>
                    <h4>ไม่พบข้อมูลบุคลากร</h4>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($user_data): ?>
    <div class="row g-4">
        <div class="col-md-6">
            <div class="card profile-card shadow-sm h-100">
                <div class="card-body">
                    <h5 class="text-success border-bottom pb-2 mb-3"><i class="fas fa-id-card"></i> ข้อมูลทั่วไปและการทำงาน</h5>
                    
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">เลขที่ตำแหน่ง</div>
                        <div class="col-sm-7"><?php echo $user_data['code']; ?></div>
                    </div>
                    <?php if(!empty($user_data['direct_pay_code'])): ?>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">เลขที่ตำแหน่งจ่ายตรง</div>
                        <div class="col-sm-7"><?php echo $user_data['direct_pay_code']; ?></div>
                    </div>
                    <?php endif; ?>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">เลขบัตรประชาชน</div>
                        <div class="col-sm-7"><?php echo $user_data['id_card']; ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">กลุ่มสาระฯ/ฝ่าย</div>
                        <div class="col-sm-7"><?php echo $user_data['department']; ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">วิทยฐานะ</div>
                        <div class="col-sm-7"><?php echo !empty($user_data['academic_standing']) ? $user_data['academic_standing'] : '-'; ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">แหล่งงบประมาณ</div>
                        <div class="col-sm-7"><?php echo !empty($user_data['budget_source']) ? $user_data['budget_source'] : '-'; ?></div>
                    </div>
                    
                    <hr class="text-muted opacity-25">

                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">วันเกิด</div>
                        <div class="col-sm-7"><?php echo DateThai($user_data['birthdate']); ?> <span class="text-primary fw-bold">(อายุ <?php echo $age; ?> ปี)</span></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">วันเกษียณอายุ</div>
                        <div class="col-sm-7 text-danger fw-bold"><?php echo $retire_date; ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">เริ่มรับราชการ</div>
                        <div class="col-sm-7"><?php echo DateThai($user_data['official_start_date']); ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-5 fw-bold text-muted">เริ่มงานที่นี่</div>
                        <div class="col-sm-7"><?php echo DateThai($user_data['start_date']); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card profile-card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="text-success border-bottom pb-2 mb-3"><i class="fas fa-graduation-cap"></i> ประวัติการศึกษา</h5>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover align-middle">
                            <thead class="table-light"><tr><th>ระดับ</th><th>วุฒิ/สาขา</th><th>ปีที่จบ</th></tr></thead>
                            <tbody>
                                <?php foreach($educations as $edu): ?>
                                <tr>
                                    <td><span class="badge bg-light text-dark border"><?php echo $edu['edu_level']; ?></span></td>
                                    <td><?php echo $edu['edu_degree']; ?><br><small class="text-muted"><?php echo $edu['edu_major']; ?></small></td>
                                    <td><?php echo DateThai($edu['edu_date']); ?></td>
                                </tr>
                                <?php endforeach; if(empty($educations)) echo "<tr><td colspan='3' class='text-center text-muted'>- ไม่มีข้อมูล -</td></tr>"; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card profile-card shadow-sm">
                <div class="card-body">
                    <h5 class="text-success border-bottom pb-2 mb-3"><i class="fas fa-address-book"></i> ข้อมูลติดต่อ & สถานะ</h5>
                    <p class="mb-2"><i class="fas fa-phone-alt text-muted me-2"></i> <?php echo $user_data['phone']; ?></p>
                    <p class="mb-2"><i class="fas fa-envelope text-muted me-2"></i> <?php echo $user_data['email']; ?></p>
                    <p class="mb-3"><i class="fas fa-map-marker-alt text-muted me-2"></i> <?php echo $user_data['address']; ?></p>
                    
                    <div class="d-flex justify-content-between align-items-center bg-light p-2 rounded">
                        <span class="fw-bold text-muted">สถานะปัจจุบัน:</span>
                        <?php 
                            $st_color = ($user_data['status'] == 'ปกติ') ? 'success' : 'secondary';
                        ?>
                        <span class="badge bg-<?php echo $st_color; ?> fs-6"><?php echo $user_data['status']; ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>