<?php 
require_once 'db.php'; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $personnel_id = $_POST['personnel_id'];
    $username = trim($_POST['username']);
    $password = md5($_POST['password']); // เข้ารหัสด้วย MD5

    // ตรวจสอบว่าเลือกชื่อไหม
    if(empty($personnel_id)) {
        echo "<script>alert('กรุณาเลือกชื่อบุคลากร');</script>";
    } else {
        // เช็คว่า Username ซ้ำไหม
        $check = $conn->prepare("SELECT COUNT(*) FROM users WHERE username = ?");
        $check->execute([$username]);
        
        if($check->fetchColumn() > 0){
            echo "<script>alert('ชื่อผู้ใช้ (Username) นี้มีคนใช้แล้ว เปลี่ยนใหม่นะครับ');</script>";
        } else {
            // บันทึกข้อมูล
            $stmt = $conn->prepare("INSERT INTO users (personnel_id, username, password, role, status) VALUES (?, ?, ?, 'user', 'active')");
            if($stmt->execute([$personnel_id, $username, $password])){
                echo "<script>alert('สมัครสมาชิกเรียบร้อย! กรุณาเข้าสู่ระบบ'); window.location='login.php';</script>";
            } else {
                echo "<script>alert('เกิดข้อผิดพลาด ลองใหม่อีกครั้ง');</script>";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>ลงทะเบียนสมาชิกใหม่</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #f8f9fa; display: flex; align-items: center; justify-content: center; height: 100vh; }
        .card-register { width: 100%; max-width: 450px; border-radius: 15px; border: none; box-shadow: 0 0 20px rgba(0,0,0,0.1); }
        .header-bg { background: linear-gradient(135deg, #006633 0%, #00b359 100%); color: white; border-radius: 15px 15px 0 0; padding: 20px; text-align: center; }
    </style>
</head>
<body>

<div class="card card-register">
    <div class="header-bg">
        <h4 class="mb-0"><i class="fas fa-user-plus"></i> ลงทะเบียนเข้าใช้งาน</h4>
        <small>สำหรับบุคลากรโรงเรียนแม่สายประสิทธิ์ศาสตร์</small>
    </div>
    <div class="card-body p-4">
        <form method="POST">
            <div class="mb-3">
                <label class="form-label fw-bold">เลือกชื่อของท่าน</label>
                <select name="personnel_id" class="form-select" required>
                    <option value="">-- ค้นหาชื่อของท่าน --</option>
                    <?php
                    // ดึงรายชื่อครูที่ "ยังไม่มีบัญชี User" มาแสดง
                    $sql = "SELECT id, firstname, lastname FROM personnel 
                            WHERE id NOT IN (SELECT personnel_id FROM users) 
                            AND status = 'ปกติ' 
                            ORDER BY firstname ASC";
                    $stmt = $conn->query($sql);
                    while($row = $stmt->fetch()){
                        echo "<option value='{$row['id']}'>{$row['firstname']} {$row['lastname']}</option>";
                    }
                    ?>
                </select>
                <div class="form-text text-danger">* หากไม่เจอชื่อ แสดงว่าท่านมีบัญชีอยู่แล้ว หรือข้อมูลยังไม่เข้าระบบ</div>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">ตั้งชื่อผู้ใช้ (Username)</label>
                <input type="text" name="username" class="form-control" placeholder="ภาษาอังกฤษ (เช่น somchai)" required>
            </div>

            <div class="mb-4">
                <label class="form-label fw-bold">ตั้งรหัสผ่าน</label>
                <input type="password" name="password" class="form-control" placeholder="กรอกรหัสผ่านที่จำได้ง่าย" required>
            </div>

            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-success">ยืนยันการลงทะเบียน</button>
                <a href="login.php" class="btn btn-outline-secondary">กลับหน้าเข้าสู่ระบบ</a>
            </div>
        </form>
    </div>
</div>

</body>
</html>