<?php 
require_once 'auth.php'; 
require_once 'db.php'; 
$is_admin = isAdmin();
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ระบบรายงานสารสนเทศ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Sarabun', sans-serif; background-color: #f8f9fa; }
        .report-section { background: white; border-radius: 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .action-btn { width: 40px; }
        .section-header { border-bottom: 2px solid #e9ecef; padding-bottom: 10px; margin-bottom: 15px; color: #198754; font-weight: bold; }
    </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container py-4">
    <h2 class="fw-bold text-success mb-4"><i class="fas fa-chart-line"></i> ระบบรายงานสารสนเทศ</h2>

    <div class="report-section">
        <h5 class="section-header"><i class="fas fa-users"></i> รายงานข้อมูลบุคลากร</h5>
        <table class="table table-hover align-middle">
            <thead class="table-light">
                <tr>
                    <th width="50%">หัวข้อรายงาน</th>
                    <th width="15%" class="text-center">พิมพ์/PDF</th>
                    <th width="15%" class="text-center">Excel</th>
                    <th width="15%" class="text-center">CSV</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $reports_personnel = [
                    ['id'=>'all', 'name'=>'รายชื่อบุคลากรทั้งหมด'],
                    ['id'=>'exec', 'name'=>'รายชื่อผู้บริหาร'],
                    ['id'=>'teacher', 'name'=>'รายชื่อข้าราชการครู'],
                    ['id'=>'gov_emp', 'name'=>'รายชื่อพนักงานราชการ'],
                    ['id'=>'emp', 'name'=>'รายชื่อลูกจ้างและอื่นๆ'],
                    ['id'=>'retire', 'name'=>'ผู้เกษียณอายุราชการ'],
                    ['id'=>'birthday', 'name'=>'วันเกิดบุคลากร (ประจำเดือนนี้)'],
                    ['id'=>'dept', 'name'=>'รายชื่อแยกตามกลุ่มสาระฯ'],
                ];
                foreach($reports_personnel as $r): 
                ?>
                <tr>
                    <td><?php echo $r['name']; ?></td>
                    <td class="text-center"><a href="print_list.php?filter=<?php echo $r['id']; ?>" target="_blank" class="btn btn-sm btn-outline-dark action-btn"><i class="fas fa-print"></i></a></td>
                    <td class="text-center"><a href="export_report.php?type=excel&report=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-success action-btn"><i class="fas fa-file-excel"></i></a></td>
                    <td class="text-center"><a href="export_report.php?type=csv&report=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-primary action-btn"><i class="fas fa-file-csv"></i></a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="report-section">
        <h5 class="section-header"><i class="fas fa-clock"></i> รายงานการปฏิบัติงาน (มาทำงาน/ลา/ไปราชการ)</h5>
        <table class="table table-hover align-middle">
            <thead class="table-light">
                <tr>
                    <th width="50%">หัวข้อรายงาน</th>
                    <th width="15%" class="text-center">พิมพ์/PDF</th>
                    <th width="15%" class="text-center">Excel</th>
                    <th width="15%" class="text-center">CSV</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $reports_work = [
                    ['id'=>'attend_present', 'name'=>'สถิติการมาทำงาน (เวลาเข้า-ออก)'],
                    ['id'=>'attend_late', 'name'=>'สถิติการมาสาย'],
                    ['id'=>'leave_history', 'name'=>'ประวัติการลา (ทั้งหมด)'],
                    ['id'=>'travel_history', 'name'=>'ประวัติการไปราชการ'],
                ];
                foreach($reports_work as $r): 
                ?>
                <tr>
                    <td><?php echo $r['name']; ?></td>
                    <td class="text-center"><a href="print_list.php?filter=<?php echo $r['id']; ?>" target="_blank" class="btn btn-sm btn-outline-dark action-btn"><i class="fas fa-print"></i></a></td>
                    <td class="text-center"><a href="export_report.php?type=excel&report=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-success action-btn"><i class="fas fa-file-excel"></i></a></td>
                    <td class="text-center"><a href="export_report.php?type=csv&report=<?php echo $r['id']; ?>" class="btn btn-sm btn-outline-primary action-btn"><i class="fas fa-file-csv"></i></a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <div class="row">
        <div class="col-md-6">
             <div class="report-section h-100">
                <h5 class="section-header"><i class="fas fa-chart-pie"></i> รายงานสถิติภาพรวม</h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between">
                        <span>สรุปจำนวนบุคลากร (แยกประเภท)</span>
                        <a href="export_report.php?type=excel&report=summary_count" class="btn btn-sm btn-success"><i class="fas fa-download"></i> Excel</a>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span>สถิติระดับการศึกษา</span>
                        <a href="export_report.php?type=excel&report=education" class="btn btn-sm btn-success"><i class="fas fa-download"></i> Excel</a>
                    </li>
                </ul>
             </div>
        </div>
        <div class="col-md-6">
             <div class="report-section h-100 bg-light border-0">
                <h5 class="fw-bold mb-3">ฐานข้อมูลรวม</h5>
                <div class="alert alert-info">
                    <i class="fas fa-database"></i> ดาวน์โหลดข้อมูลดิบทั้งหมด (Raw Data)
                </div>
                <a href="export_report.php?type=excel&report=full_db" class="btn btn-primary w-100 py-3 fw-bold">
                    <i class="fas fa-file-download"></i> ดาวน์โหลดฐานข้อมูลบุคลากร (Excel)
                </a>
             </div>
        </div>
    </div>

</div>

<?php include 'footer.php'; ?>
</body>
</html>