<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

if (!isAdmin()) { header("location: index.php"); exit; }
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ถังขยะ - ข้อมูลที่ถูกลบ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { font-family: 'Sarabun', sans-serif; background-color: #f8f9fa; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container mt-4">
    <div class="card border-danger shadow-sm">
        <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fas fa-trash-alt"></i> ถังขยะ (Deleted Items)</h4>
            <a href="personnel.php" class="btn btn-light btn-sm fw-bold text-danger">
                <i class="fas fa-arrow-left"></i> กลับไปหน้ารายชื่อ
            </a>
        </div>
        <div class="card-body">
            <div class="alert alert-warning">
                <i class="fas fa-info-circle"></i> รายชื่อในหน้านี้คือข้อมูลที่ถูกลบไปแล้ว 
                <br>• กด <strong>"กู้คืน"</strong> เพื่อนำกลับไปใช้งาน 
                <br>• กด <strong>"ลบถาวร"</strong> เพื่อลบออกจากฐานข้อมูลทันที (กู้ไม่ได้)
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ชื่อ-นามสกุล</th>
                            <th>ตำแหน่ง</th>
                            <th>สถานะ</th>
                            <th class="text-center">จัดการ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // ดึงข้อมูลเฉพาะคนที่ถูกลบ (is_deleted = 1)
                        $sql = "SELECT * FROM personnel WHERE is_deleted = 1 ORDER BY id DESC";
                        $stmt = $conn->query($sql);
                        
                        if ($stmt->rowCount() > 0):
                            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)): 
                        ?>
                            <tr>
                                <td>
                                    <?php echo $row['prefix'] . $row['firstname'] . ' ' . $row['lastname']; ?>
                                </td>
                                <td><small><?php echo $row['position_type']; ?></small></td>
                                <td><span class="badge bg-secondary">ถูกลบ</span></td>
                                <td class="text-center">
                                    <div class="btn-group">
                                        <a href="personnel_restore.php?id=<?php echo $row['id']; ?>" 
                                           class="btn btn-success btn-sm fw-bold"
                                           onclick="return confirm('ยืนยันการกู้คืนข้อมูลนี้?');">
                                           <i class="fas fa-trash-restore"></i> กู้คืน
                                        </a>
                                        
                                        <a href="personnel_delete_permanent.php?id=<?php echo $row['id']; ?>" 
                                           class="btn btn-danger btn-sm fw-bold"
                                           onclick="return confirm('คำเตือน: คุณต้องการลบข้อมูลนี้ถาวรใช่ไหม? ข้อมูลจะกู้คืนไม่ได้!');">
                                           <i class="fas fa-times"></i> ลบถาวร
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php 
                            endwhile;
                        else: 
                        ?>
                            <tr><td colspan="4" class="text-center text-muted py-4">ไม่มีข้อมูลในถังขยะ</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>