<?php 
require_once 'auth.php'; 
require_once 'db.php'; 
date_default_timezone_set('Asia/Bangkok');
$today = date('Y-m-d');
$is_admin = isAdmin();
$my_id = $_SESSION['personnel_id'];

// (Logic PHP เดิม... บันทึก/ลบ ใส่ไว้ตรงนี้เหมือนไฟล์เดิมนะครับ)
// ... เพื่อความกระชับ ผมขอข้ามส่วน Logic PHP ไปที่ HTML เลย (คุณครูใช้ Logic เดิมได้เลย)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['btnCheckIn'])) {
   // ... (Logic เดิม) ...
   // ก็อปปี้ Logic PHP จากไฟล์เก่ามาใส่ตรงนี้ได้เลยครับ
     try {
        $pid = $_POST['personnel_id'];
        $check_in = $_POST['check_in_time'];
        $status = ($check_in > '08:30:00') ? 'สาย' : 'ปกติ';
        $check = $conn->query("SELECT COUNT(*) FROM attendance WHERE personnel_id = '$pid' AND work_date = '$today'")->fetchColumn();
        if ($check > 0) { echo "<script>alert('ลงเวลาไปแล้วครับ');</script>"; } 
        else {
            $stmt = $conn->prepare("INSERT INTO attendance (personnel_id, work_date, check_in, status) VALUES (?, ?, ?, ?)");
            $stmt->execute([$pid, $today, $check_in, $status]);
            echo "<script>alert('บันทึกเรียบร้อย'); window.location='attendance.php';</script>";
        }
    } catch (PDOException $e) { echo "<script>alert('Error');</script>"; }
}
if (isset($_GET['delete_id'])) {
    $conn->prepare("DELETE FROM attendance WHERE id = ?")->execute([$_GET['delete_id']]);
    header("Location: attendance.php"); exit();
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ลงเวลาปฏิบัติราชการ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container p-3 p-md-4 bg-white rounded shadow-sm mt-3">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 gap-3">
        <div>
            <h3 class="mb-0 text-success"><i class="fas fa-clock"></i> ลงเวลาวันนี้</h3>
            <small class="text-muted"><?php echo DateThai($today); ?></small>
        </div>
        <button class="btn btn-primary w-100 w-md-auto shadow" data-bs-toggle="modal" data-bs-target="#checkInModal">
            <i class="fas fa-fingerprint"></i> ลงเวลาเข้างาน
        </button>
    </div>

    <div class="row g-2 mb-3">
        <?php 
        $c_ok = $conn->query("SELECT COUNT(*) FROM attendance WHERE work_date='$today' AND status='ปกติ'")->fetchColumn();
        $c_late = $conn->query("SELECT COUNT(*) FROM attendance WHERE work_date='$today' AND status='สาย'")->fetchColumn();
        ?>
        <div class="col-6 col-md-3">
            <div class="alert alert-success mb-0 py-2 text-center"><i class="fas fa-check-circle"></i> ปกติ: <strong><?php echo $c_ok; ?></strong></div>
        </div>
        <div class="col-6 col-md-3">
            <div class="alert alert-warning mb-0 py-2 text-center"><i class="fas fa-exclamation-circle"></i> สาย: <strong><?php echo $c_late; ?></strong></div>
        </div>
    </div>

    <div class="table-responsive">
        <table id="attendanceTable" class="table table-striped table-hover align-middle w-100">
            <thead class="table-dark">
                <tr>
                    <th>ที่</th>
                    <th>ชื่อ-นามสกุล</th>
                    <th>ตำแหน่ง</th>
                    <th>เวลา</th>
                    <th>สถานะ</th>
                    <th>ลบ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT a.*, p.firstname, p.lastname, p.prefix, p.position_type 
                        FROM attendance a JOIN personnel p ON a.personnel_id = p.id 
                        WHERE a.work_date = '$today' ORDER BY a.check_in DESC";
                $stmt = $conn->query($sql);
                $i = 1;
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $bg = ($row['status'] == 'สาย') ? 'warning text-dark' : 'success';
                    echo "<tr>
                        <td>{$i}</td>
                        <td class='fw-bold text-nowrap'>{$row['prefix']}{$row['firstname']} {$row['lastname']}</td>
                        <td><small>{$row['position_type']}</small></td>
                        <td class='fw-bold text-primary'>{$row['check_in']}</td>
                        <td><span class='badge bg-{$bg}'>{$row['status']}</span></td>
                        <td>";
                    if($is_admin || $row['personnel_id'] == $my_id) { // ลบของตัวเองได้ หรือแอดมินลบได้
                        echo "<a href='attendance.php?delete_id={$row['id']}' class='btn btn-sm btn-outline-danger' onclick=\"return confirm('ลบ?')\"><i class='fas fa-trash'></i></a>";
                    }
                    echo "</td></tr>";
                    $i++;
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="checkInModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">ลงเวลาเข้างาน</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="fw-bold">ชื่อบุคลากร</label>
                         <?php if(!$is_admin): ?>
                            <?php $me = $conn->query("SELECT firstname, lastname FROM personnel WHERE id=$my_id")->fetch(); ?>
                            <input type="text" class="form-control" value="<?php echo $me['firstname'].' '.$me['lastname']; ?>" readonly>
                            <input type="hidden" name="personnel_id" value="<?php echo $my_id; ?>">
                        <?php else: ?>
                            <select name="personnel_id" class="form-select" required>
                                <option value="">-- เลือก --</option>
                                <?php
                                $s = $conn->query("SELECT id, firstname, lastname FROM personnel WHERE status='ปกติ'");
                                while($r=$s->fetch()) echo "<option value='{$r['id']}'>{$r['firstname']} {$r['lastname']}</option>";
                                ?>
                            </select>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label>เวลา</label>
                        <input type="time" name="check_in_time" class="form-control" value="<?php echo date('H:i'); ?>">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="btnCheckIn" class="btn btn-primary w-100">ยืนยัน</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script> $(document).ready(function() { $('#attendanceTable').DataTable({ "scrollX": true, "language": { "url": "//cdn.datatables.net/plug-ins/1.13.4/i18n/th.json" } }); }); </script>
</body>
</html>