<?php
require_once 'auth.php';
require_once 'db.php';

if (isset($_GET['act']) && $_GET['act'] == 'excel') {
    // ตั้งค่า Header ให้ Browser รู้ว่าเป็นไฟล์ Excel (CSV)
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=personnel_data_' . date('Y-m-d') . '.csv');

    // สร้าง Output Stream
    $output = fopen('php://output', 'w');

    // เขียน BOM สำหรับรองรับภาษาไทยใน Excel
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

    // เขียนหัวตาราง
    fputcsv($output, array('รหัส', 'คำนำหน้า', 'ชื่อ', 'นามสกุล', 'ตำแหน่ง', 'วิทยฐานะ', 'กลุ่มสาระ', 'เบอร์โทร', 'สถานะ'));

    // ดึงข้อมูล
    $stmt = $conn->query("SELECT * FROM personnel ORDER BY position_type, firstname");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        fputcsv($output, array(
            $row['code'],
            $row['prefix'],
            $row['firstname'],
            $row['lastname'],
            $row['position_type'],
            $row['position_level'],
            $row['department'],
            '-', // เบอร์โทร (ถ้ามี column ใน db ก็ใส่ตัวแปรแทน)
            $row['status']
        ));
    }
    fclose($output);
    exit();
}
?>