<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

// ตั้งค่า Timezone
date_default_timezone_set('Asia/Bangkok');
$today = date('Y-m-d');
$current_month = date('m');

// --- 1. Query ข้อมูล Dashboard หลัก ---
$total_staff = $conn->query("SELECT COUNT(*) FROM personnel WHERE status = 'ปกติ'")->fetchColumn();
$present_count = $conn->query("SELECT COUNT(*) FROM attendance WHERE work_date = '$today'")->fetchColumn();
$late_count = $conn->query("SELECT COUNT(*) FROM attendance WHERE work_date = '$today' AND status = 'สาย'")->fetchColumn();
$on_leave = $conn->query("SELECT COUNT(*) FROM leaves WHERE '$today' BETWEEN start_date AND end_date AND status = 'อนุมัติ'")->fetchColumn();

// คำนวณขาดงาน
$absent_count = $total_staff - ($present_count + $on_leave);
if ($absent_count < 0) $absent_count = 0;

// วันเกิด & เกษียณ
$bd_month = $conn->query("SELECT COUNT(*) FROM personnel WHERE MONTH(birthdate) = '$current_month' AND status = 'ปกติ'")->fetchColumn();
$bd_today = $conn->query("SELECT COUNT(*) FROM personnel WHERE DATE_FORMAT(birthdate, '%m-%d') = DATE_FORMAT('$today', '%m-%d') AND status = 'ปกติ'")->fetchColumn();
$retire_target = (date('Y') - 60) . "-10-01";
$retire_count = $conn->query("SELECT COUNT(*) FROM personnel WHERE birthdate <= '$retire_target' AND status = 'ปกติ'")->fetchColumn();

// --- 2. คำนวณค่าเฉลี่ยและสัดส่วน ---
// 2.1 อายุเฉลี่ย
$sql_age = "SELECT AVG(TIMESTAMPDIFF(YEAR, birthdate, CURDATE())) FROM personnel WHERE status = 'ปกติ' AND birthdate IS NOT NULL AND birthdate != '0000-00-00'";
$avg_age = $conn->query($sql_age)->fetchColumn();
$avg_age = number_format($avg_age, 0); 

// 2.2 สัดส่วนเพศ
$sql_male_all = "SELECT COUNT(*) FROM personnel WHERE status = 'ปกติ' AND (prefix = 'นาย' OR prefix LIKE 'ว่าที่ร้อยตรี%' OR prefix LIKE 'เด็กชาย%' OR prefix LIKE 'พระ%')";
$total_male = $conn->query($sql_male_all)->fetchColumn();
$total_female = $total_staff - $total_male;

// --- 3. ข้อมูลสถิติเชิงลึก ---

// 3.1 ระดับการศึกษา
function getEduCount($conn, $level) {
    $sql = "SELECT COUNT(DISTINCT p.id) FROM personnel p 
            JOIN personnel_education pe ON p.id = pe.personnel_id 
            WHERE p.status = 'ปกติ' AND pe.edu_level LIKE ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute(["%$level%"]);
    return $stmt->fetchColumn();
}
$edu_bach = getEduCount($conn, 'ปริญญาตรี');
$edu_master = getEduCount($conn, 'ปริญญาโท');
$edu_phd = getEduCount($conn, 'ปริญญาเอก');

// 3.2 วิทยฐานะ
$academic_stats = [];
$stmt = $conn->query("SELECT academic_standing, COUNT(*) as count FROM personnel WHERE status='ปกติ' AND academic_standing != '' GROUP BY academic_standing ORDER BY count DESC");
while($row = $stmt->fetch()) {
    $academic_stats[] = $row;
}

// 3.3 กลุ่มสาระฯ
$dept_stats = [];
$stmt = $conn->query("SELECT department, COUNT(*) as count FROM personnel WHERE status='ปกติ' AND department != '' GROUP BY department ORDER BY count DESC");
while($row = $stmt->fetch()) {
    $dept_stats[] = $row;
}

// --- 4. ข้อมูลรายชื่อแยกประเภท (ฝั่งขวา) ---
// *** เพิ่มหมวด 'บุคลากรสนับสนุน' เข้าไปเพื่อให้ครอบคลุมเจ้าหน้าที่ธุรการและนักการภารโรง ***
$categories = [
    'ผู้บริหาร' => ['ผู้อำนวยการ', 'รองผู้อำนวยการ'],
    'ข้าราชการครู' => ['ครู', 'ครูผู้ช่วย'],
    'พนักงานราชการ' => ['พนักงานราชการ'],
    'ครูอัตราจ้าง' => ['อัตราจ้าง', 'ครูอัตราจ้าง'],
    'ลูกจ้างประจำ' => ['ลูกจ้างประจำ'],
    'ลูกจ้างชั่วคราว' => ['ลูกจ้างชั่วคราว'],
    'จ้างเหมาบริการ' => ['จ้างเหมาบริการ'],
    'บุคลากรสนับสนุน' => ['เจ้าหน้าที่ธุรการ', 'นักการภารโรง', 'เจ้าหน้าที่', 'ธุรการ'] 
];

$personnel_stats = [];
foreach ($categories as $label => $types) {
    $placeholders = implode(',', array_fill(0, count($types), '?'));
    $sqlTotal = "SELECT COUNT(*) FROM personnel WHERE status = 'ปกติ' AND position_type IN ($placeholders)";
    $stmt = $conn->prepare($sqlTotal);
    $stmt->execute($types);
    $total = $stmt->fetchColumn();

    $sqlMale = "SELECT COUNT(*) FROM personnel WHERE status = 'ปกติ' AND position_type IN ($placeholders) AND (prefix = 'นาย' OR prefix LIKE 'ว่าที่ร้อยตรี%' OR prefix LIKE 'เด็กชาย%' OR prefix LIKE 'พระ%')";
    $stmt = $conn->prepare($sqlMale);
    $stmt->execute($types);
    $male = $stmt->fetchColumn();

    $sqlFemale = "SELECT COUNT(*) FROM personnel WHERE status = 'ปกติ' AND position_type IN ($placeholders) AND (prefix = 'นาง' OR prefix = 'นางสาว' OR prefix = 'น.ส.' OR prefix LIKE 'เด็กหญิง%')";
    $stmt = $conn->prepare($sqlFemale);
    $stmt->execute($types);
    $female = $stmt->fetchColumn();

    $personnel_stats[$label] = [ 'total' => $total, 'male' => $male, 'female' => $female ];
}

function calcPct($val, $total) {
    return ($total > 0) ? number_format(($val / $total) * 100, 1) : 0;
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="uploads/logo.png">
    <title>ระบบบริหารงานบุคคล - โรงเรียนแม่สายประสิทธิ์ศาสตร์</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        /* Card Style */
        .card-stat { 
            border-radius: 15px; border: none; color: white; overflow: hidden; position: relative;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-bottom: 10px;
        }
        .icon-bg { 
            position: absolute; right: 10px; bottom: 5px; opacity: 0.2; font-size: 4rem; transition: 0.3s;
        }
        .card-footer-link { 
            background: rgba(0,0,0,0.15); display: block; padding: 8px; color: white; text-align: center; text-decoration: none; font-size: 0.9rem;
        }
        
        /* Gradients */
        .bg-gradient-total { background: linear-gradient(45deg, #11998e, #38ef7d); }
        .bg-gradient-present { background: linear-gradient(45deg, #2193b0, #6dd5ed); }
        .bg-gradient-late { background: linear-gradient(45deg, #f7971e, #ffd200); }
        .bg-gradient-leave { background: linear-gradient(45deg, #8B4513, #A0522D) !important; color: white; }
        .bg-gradient-absent { background: linear-gradient(45deg, #DC3545, #C82333) !important; color: white; }
        .bg-gradient-bd { background: linear-gradient(45deg, #834d9b, #d04ed6); }
        .bg-gradient-retire { background: linear-gradient(45deg, #2C3E50, #4CA1AF); }

        .stat-item { transition: background-color 0.2s; }
        .stat-item:hover { background-color: #f8f9fa; }
        .gender-badge { font-size: 0.85rem; min-width: 60px; display: inline-block; text-align: center; }

        .info-box {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            text-align: center;
            border: 1px solid #e9ecef;
        }
        .info-label { font-size: 0.85rem; color: #6c757d; font-weight: bold; }
        .info-value { font-size: 1.2rem; font-weight: bold; color: #198754; }

        /* Progress Bar Custom */
        .progress-xs { height: 6px; border-radius: 3px; }
        .stat-row-label { font-size: 0.9rem; color: #555; }
        .stat-row-val { font-size: 0.9rem; font-weight: bold; color: #333; }
        .sub-header { font-size: 1rem; font-weight: bold; color: #198754; border-bottom: 2px solid #e9ecef; padding-bottom: 5px; margin-bottom: 15px; margin-top: 20px; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container py-3">
    <div class="alert alert-light border-start border-5 border-success shadow-sm mb-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div>
                <h5 class="mb-0 text-success fw-bold"><i class="fas fa-tachometer-alt"></i> แดชบอร์ด</h5>
                <small class="text-muted" style="font-size: 0.8rem;">ข้อมูล ณ วันที่ <?php echo DateThai($today); ?></small>
            </div>
            <div class="mt-2 mt-md-0">
                <span class="badge bg-success rounded-pill">ปีการศึกษา 2568</span>
            </div>
        </div>
    </div>

    <div class="row g-3 mb-3">
        <div class="col-6 col-lg-3">
            <div class="card card-stat bg-gradient-total h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">ทั้งหมด</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $total_staff; ?></h2>
                    <i class="fas fa-users icon-bg"></i>
                </div>
                <a href="personnel.php" class="card-footer-link">ดูรายชื่อ <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card card-stat bg-gradient-present h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">มาทำงาน</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $present_count; ?></h2>
                    <i class="fas fa-user-check icon-bg"></i>
                </div>
                <a href="attendance.php" class="card-footer-link">เช็คเวลา <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card card-stat bg-gradient-leave h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">ลา</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $on_leave; ?></h2>
                    <i class="fas fa-bed icon-bg"></i>
                </div>
                <a href="leaves.php" class="card-footer-link">ข้อมูลลา <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card card-stat bg-gradient-late h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">สาย</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $late_count; ?></h2>
                    <i class="fas fa-running icon-bg"></i>
                </div>
                <a href="attendance.php" class="card-footer-link">ดูรายชื่อ <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-12 col-md-4">
            <div class="card card-stat bg-gradient-absent h-100">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-uppercase small fw-bold">ขาดงาน/ไม่ลงเวลา</h6>
                        <h2 class="display-5 fw-bold mb-0"><?php echo $absent_count; ?></h2>
                    </div>
                    <i class="fas fa-user-slash icon-bg position-static fs-1 opacity-50"></i>
                </div>
                <a href="attendance.php" class="card-footer-link">ตรวจสอบ <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
        <div class="col-6 col-md-4">
            <div class="card card-stat bg-gradient-bd h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">วันเกิดเดือนนี้</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $bd_month; ?></h2>
                    <?php if($bd_today > 0): ?>
                        <span class="badge bg-white text-dark mt-1">วันนี้: <?php echo $bd_today; ?></span>
                    <?php endif; ?>
                    <i class="fas fa-birthday-cake icon-bg"></i>
                </div>
                <a href="birthdays.php" class="card-footer-link">ปฏิทิน <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
        <div class="col-6 col-md-4">
            <div class="card card-stat bg-gradient-retire h-100">
                <div class="card-body">
                    <h6 class="text-uppercase small fw-bold">เตรียมเกษียณ</h6>
                    <h2 class="display-5 fw-bold mb-0"><?php echo $retire_count; ?></h2>
                    <i class="fas fa-user-clock icon-bg"></i>
                </div>
                <a href="retirement.php" class="card-footer-link">ดูรายชื่อ <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row g-4">
        
        <div class="col-12 col-lg-7">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 text-success fw-bold"><i class="fas fa-chart-pie"></i> สัดส่วนและค่าเฉลี่ยบุคลากร</h6>
                </div>
                <div class="card-body p-4">
                    
                    <div class="row g-3 mb-3">
                        <div class="col-6">
                            <div class="info-box">
                                <div class="info-label"><i class="fas fa-hourglass-half"></i> อายุเฉลี่ย</div>
                                <div class="info-value"><?php echo $avg_age; ?> ปี</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="info-box">
                                <div class="info-label"><i class="fas fa-venus-mars"></i> สัดส่วน (ชาย:หญิง)</div>
                                <div class="info-value text-primary">
                                    <?php echo $total_male; ?> : <span class="text-danger"><?php echo $total_female; ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="piechart" style="width: 100%; min-height: 250px;"></div>

                    <div class="sub-header"><i class="fas fa-graduation-cap"></i> ระดับการศึกษา</div>
                    <div class="mb-2">
                        <div class="d-flex justify-content-between">
                            <span class="stat-row-label">ปริญญาเอก</span>
                            <span class="stat-row-val"><?php echo $edu_phd; ?> คน (<?php echo calcPct($edu_phd, $total_staff); ?>%)</span>
                        </div>
                        <div class="progress progress-xs"><div class="progress-bar bg-primary" style="width: <?php echo calcPct($edu_phd, $total_staff); ?>%"></div></div>
                    </div>
                    <div class="mb-2">
                        <div class="d-flex justify-content-between">
                            <span class="stat-row-label">ปริญญาโท</span>
                            <span class="stat-row-val"><?php echo $edu_master; ?> คน (<?php echo calcPct($edu_master, $total_staff); ?>%)</span>
                        </div>
                        <div class="progress progress-xs"><div class="progress-bar bg-info" style="width: <?php echo calcPct($edu_master, $total_staff); ?>%"></div></div>
                    </div>
                    <div class="mb-2">
                        <div class="d-flex justify-content-between">
                            <span class="stat-row-label">ปริญญาตรี</span>
                            <span class="stat-row-val"><?php echo $edu_bach; ?> คน (<?php echo calcPct($edu_bach, $total_staff); ?>%)</span>
                        </div>
                        <div class="progress progress-xs"><div class="progress-bar bg-success" style="width: <?php echo calcPct($edu_bach, $total_staff); ?>%"></div></div>
                    </div>

                    <div class="sub-header"><i class="fas fa-star"></i> วิทยฐานะ</div>
                    <div class="row g-2">
                        <?php foreach($academic_stats as $ac): ?>
                        <div class="col-6 col-sm-4">
                            <div class="p-2 border rounded bg-white text-center">
                                <div class="small text-muted text-truncate"><?php echo $ac['academic_standing']; ?></div>
                                <div class="fw-bold text-success"><?php echo $ac['count']; ?> คน</div>
                                <div style="font-size: 0.75rem; color: #999;"><?php echo calcPct($ac['count'], $total_staff); ?>%</div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="sub-header"><i class="fas fa-book-reader"></i> กลุ่มสาระฯ / ฝ่าย</div>
                    <div style="max-height: 200px; overflow-y: auto;">
                        <ul class="list-group list-group-flush small">
                            <?php foreach($dept_stats as $dp): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                <span><?php echo $dp['department']; ?></span>
                                <span class="badge bg-light text-dark border"><?php echo $dp['count']; ?> คน (<?php echo calcPct($dp['count'], $total_staff); ?>%)</span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-12 col-lg-5">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 text-primary fw-bold"><i class="fas fa-list-ol"></i> สรุปจำนวนบุคลากร</h6>
                    <span class="badge bg-primary rounded-pill"><?php echo $total_staff; ?> คน</span>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php foreach($personnel_stats as $name => $stat): ?>
                        <div class="list-group-item stat-item py-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="fw-bold text-dark"><?php echo $name; ?></span>
                                <span class="badge bg-secondary rounded-pill"><?php echo $stat['total']; ?></span>
                            </div>
                            <div class="d-flex justify-content-end gap-2">
                                <span class="gender-badge badge bg-info bg-opacity-10 text-primary border border-info">
                                    <i class="fas fa-male"></i> ชาย <?php echo $stat['male']; ?>
                                </span>
                                <span class="gender-badge badge bg-danger bg-opacity-10 text-danger border border-danger">
                                    <i class="fas fa-female"></i> หญิง <?php echo $stat['female']; ?>
                                </span>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer bg-white text-center py-2">
                    <a href="print_list.php" target="_blank" class="btn btn-sm btn-outline-dark"><i class="fas fa-print"></i> พิมพ์รายงานสรุป</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
  google.charts.load('current', {'packages':['corechart']});
  google.charts.setOnLoadCallback(drawChart);

  function drawChart() {
    var data = google.visualization.arrayToDataTable([
      ['ประเภท', 'จำนวน'],
      <?php
      $stmt = $conn->query("SELECT position_type, COUNT(*) as count FROM personnel WHERE status='ปกติ' GROUP BY position_type");
      while($row = $stmt->fetch()){
          echo "['{$row['position_type']}', {$row['count']}],";
      }
      ?>
    ]);

    var options = {
      pieHole: 0.4,
      colors: ['#00b359', '#ffc107', '#17a2b8', '#dc3545', '#6c757d', '#6f42c1', '#fd7e14'],
      legend: { position: 'bottom', maxLines: 2 },
      chartArea: {width: '95%', height: '70%'},
      fontSize: 13,
      fontName: 'Sarabun'
    };

    var chart = new google.visualization.PieChart(document.getElementById('piechart'));
    chart.draw(data, options);
  }

  window.addEventListener('resize', drawChart);
</script>

</body>
</html>