<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

// ตั้งค่าเริ่มต้น
$is_admin = isAdmin(); 
$my_id = $_SESSION['personnel_id'];

// --- ส่วนบันทึกข้อมูล ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (isset($_POST['btnSave'])) {
            // คำนวณวันลา
            $pid = ($is_admin && !empty($_POST['personnel_id'])) ? $_POST['personnel_id'] : $my_id;
            $start = strtotime($_POST['start_date']);
            $end = strtotime($_POST['end_date']);
            $diff = $end - $start;
            $days = round($diff / (60 * 60 * 24)) + 1;
            
            // เพิ่มการป้องกัน SQL Error
            $topic = isset($_POST['topic']) ? $_POST['topic'] : '';
            $contact = isset($_POST['contact']) ? $_POST['contact'] : '';

            $stmt = $conn->prepare("INSERT INTO leaves (personnel_id, leave_type, topic, start_date, end_date, amount_day, contact, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'รออนุมัติ')");
            $stmt->execute([$pid, $_POST['leave_type'], $topic, $_POST['start_date'], $_POST['end_date'], $days, $contact]);
            
            echo "<script>alert('ส่งใบลาเรียบร้อย'); window.location='leaves.php';</script>";
            
        } elseif (isset($_POST['btnUpdate'])) {
            $stmt = $conn->prepare("UPDATE leaves SET personnel_id=?, leave_type=?, topic=?, start_date=?, end_date=?, amount_day=?, contact=?, status=? WHERE id=?");
            $stmt->execute([
                $_POST['personnel_id'], $_POST['leave_type'], $_POST['topic'], 
                $_POST['start_date'], $_POST['end_date'], $_POST['amount_day'], 
                $_POST['contact'], $_POST['status'], $_POST['id']
            ]);
            echo "<script>alert('อัปเดตสถานะเรียบร้อย'); window.location='leaves.php';</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('เกิดข้อผิดพลาด: " . $e->getMessage() . "');</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ระบบการลา</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container p-3 p-md-4 bg-white rounded shadow-sm mt-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h3 class="text-danger mb-0 fw-bold"><i class="fas fa-file-medical"></i> ระบบการลา</h3>
            <small class="text-muted"><?php echo $is_admin ? "จัดการวันลาทั้งหมด" : "ประวัติการลาของคุณ"; ?></small>
        </div>
        <button class="btn btn-danger btn-sm shadow-sm" onclick="openModal('add')">
            <i class="fas fa-plus"></i> เขียนใบลา
        </button>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-nowrap">
            <thead class="table-danger">
                <tr>
                    <th>วันที่ลา</th>
                    <th>จำนวน</th>
                    <?php if($is_admin) echo "<th>ผู้ลา</th>"; ?>
                    <th>ประเภท</th>
                    <th>เรื่อง</th>
                    <th>สถานะ</th>
                    <th>จัดการ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT l.*, p.firstname, p.lastname, p.prefix 
                        FROM leaves l 
                        JOIN personnel p ON l.personnel_id = p.id ";
                
                if (!$is_admin) {
                    $sql .= " WHERE l.personnel_id = '$my_id' ";
                }
                $sql .= " ORDER BY l.start_date DESC";

                $stmt = $conn->query($sql);
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    // แก้ไขจุดที่ Error: ถ้าไม่มีข้อมูลให้ใส่ค่า default
                    $amount = isset($row['amount_day']) ? $row['amount_day'] : 0;
                    $topic = isset($row['topic']) ? $row['topic'] : '-';
                    
                    $badge = match($row['status']) {
                        'อนุมัติ' => 'success',
                        'ไม่อนุมัติ' => 'danger',
                        default => 'warning text-dark'
                    };
                    
                    // JSON สำหรับ Modal
                    $json = htmlspecialchars(json_encode($row, JSON_UNESCAPED_UNICODE), ENT_QUOTES, 'UTF-8');

                    echo "<tr>";
                    echo "<td>".DateThai($row['start_date'])."<br><small class='text-muted'>ถึง ".DateThai($row['end_date'])."</small></td>";
                    echo "<td class='text-center fw-bold'>{$amount} วัน</td>";
                    
                    if($is_admin) {
                        echo "<td class='text-primary'>{$row['prefix']}{$row['firstname']}</td>";
                    }

                    echo "<td>{$row['leave_type']}</td>";
                    echo "<td>{$topic}</td>";
                    echo "<td><span class='badge bg-{$badge}'>{$row['status']}</span></td>";
                    echo "<td>
                        <div class='btn-group'>
                            <button class='btn btn-sm btn-warning' data-leave='{$json}' onclick='openModal(\"edit\", this)'><i class='fas fa-edit'></i></button>";
                            
                    if($is_admin || $row['status']=='รออนุมัติ') {
                        echo "<a href='delete_leave.php?id={$row['id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('ยืนยันการลบ?')\"><i class='fas fa-trash'></i></a>";
                    }
                    echo "</div></td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="leaveModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST">
                <input type="hidden" name="id" id="l_id">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="modalTitle">แบบฟอร์มการลา</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <?php if($is_admin): ?>
                    <div class="card bg-light mb-3 border-warning">
                        <div class="card-body py-2">
                            <label class="fw-bold">สถานะ:</label>
                            <select name="status" id="l_status" class="form-select w-auto d-inline-block ms-2">
                                <option value="รออนุมัติ">รออนุมัติ</option>
                                <option value="อนุมัติ">อนุมัติ</option>
                                <option value="ไม่อนุมัติ">ไม่อนุมัติ</option>
                            </select>
                            
                            <div class="mt-2">
                                <label class="fw-bold">ผู้ลา:</label>
                                <select name="personnel_id" id="l_personnel_id" class="form-select">
                                    <?php
                                    $pp = $conn->query("SELECT id, firstname, lastname FROM personnel WHERE status='ปกติ' ORDER BY firstname");
                                    while($x=$pp->fetch()) echo "<option value='{$x['id']}'>{$x['firstname']} {$x['lastname']}</option>";
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">ประเภทการลา</label>
                            <select name="leave_type" id="l_leave_type" class="form-select">
                                <option>ลาป่วย</option>
                                <option>ลากิจส่วนตัว</option>
                                <option>ลาพักผ่อน</option>
                                <option>ลาคลอดบุตร</option>
                                <option>อื่น ๆ</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">จำนวนวัน</label>
                            <input type="number" name="amount_day" id="l_amount_day" class="form-control" value="1" readonly>
                            <small class="text-muted">*คำนวณอัตโนมัติจากวันที่</small>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-6">
                            <label class="form-label">เริ่มวันที่</label>
                            <input type="date" name="start_date" id="l_start_date" class="form-control" required onchange="calcDays()">
                        </div>
                        <div class="col-6">
                            <label class="form-label">ถึงวันที่</label>
                            <input type="date" name="end_date" id="l_end_date" class="form-control" required onchange="calcDays()">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">เหตุผลการลา</label>
                        <input type="text" name="topic" id="l_topic" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">ติดต่อได้ที่</label>
                        <input type="text" name="contact" id="l_contact" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="btnSave" id="btnSave" class="btn btn-danger w-100 w-md-auto">ส่งใบลา</button>
                    <?php if($is_admin): ?>
                        <button type="submit" name="btnUpdate" id="btnUpdate" class="btn btn-warning w-100 w-md-auto d-none">บันทึกสถานะ</button>
                    <?php endif; ?>
                    <button type="button" class="btn btn-secondary w-100 w-md-auto" data-bs-dismiss="modal">ปิด</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function calcDays() {
    var start = new Date(document.getElementById('l_start_date').value);
    var end = new Date(document.getElementById('l_end_date').value);
    if(start && end && end >= start) {
        var diff = end - start;
        var days = (diff / (1000 * 60 * 60 * 24)) + 1;
        document.getElementById('l_amount_day').value = days;
    }
}

function openModal(mode, btn = null) {
    var myModal = new bootstrap.Modal(document.getElementById('leaveModal'));
    document.querySelector('form').reset(); // ล้างค่า

    if(mode == 'add') { 
        document.getElementById('modalTitle').innerText = 'เขียนใบลา'; 
        document.getElementById('btnSave').classList.remove('d-none');
        if(document.getElementById('btnUpdate')) document.getElementById('btnUpdate').classList.add('d-none');
        
        // ตั้งค่าวันที่ปัจจุบัน
        document.getElementById('l_start_date').valueAsDate = new Date();
        document.getElementById('l_end_date').valueAsDate = new Date();
    } else {
        document.getElementById('modalTitle').innerText = 'แก้ไข / อนุมัติ';
        var data = JSON.parse(btn.getAttribute('data-leave'));
        
        document.getElementById('l_id').value = data.id;
        document.getElementById('l_leave_type').value = data.leave_type;
        document.getElementById('l_topic').value = data.topic;
        document.getElementById('l_start_date').value = data.start_date;
        document.getElementById('l_end_date').value = data.end_date;
        document.getElementById('l_amount_day').value = data.amount_day;
        document.getElementById('l_contact').value = data.contact;
        
        document.getElementById('btnSave').classList.add('d-none');
        if(document.getElementById('btnUpdate')) {
            document.getElementById('btnUpdate').classList.remove('d-none');
            document.getElementById('l_status').value = data.status;
            document.getElementById('l_personnel_id').value = data.personnel_id;
        }
    }
    myModal.show();
}
</script>

</body>
</html>