<?php
session_start();
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = md5($_POST['password']); // ต้องตรงกับตอนสมัคร (MD5)

    // ตรวจสอบข้อมูลในฐานข้อมูล
    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ? AND password = ? AND status = 'active'");
    $stmt->execute([$username, $password]);
    $user = $stmt->fetch();

    if ($user) {
        // ล็อกอินสำเร็จ! เก็บข้อมูลลง Session
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['personnel_id'] = $user['personnel_id']; // รหัสบุคลากร (สำคัญมาก เอาไปใช้ดึงข้อมูลส่วนตัว)
        $_SESSION['role'] = $user['role']; // user หรือ admin
        $_SESSION['username'] = $user['username'];

        // ไปที่หน้าแรก (Dashboard)
        header("Location: index.php");
        exit();
    } else {
        $error = "ชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง (หรือบัญชีถูกระงับ)";
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>เข้าสู่ระบบ - HR Maesai</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: linear-gradient(135deg, #006633 0%, #00b359 100%); height: 100vh; display: flex; align-items: center; justify-content: center; }
        .card-login { width: 100%; max-width: 400px; border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
        .logo-img { width: 100px; margin-bottom: 15px; }
    </style>
</head>
<body>

<div class="card card-login p-4 bg-white text-center">
    <img src="https://www.maesai.ac.th/web/wp-content/uploads/2024/06/images.png" class="logo-img mx-auto">
    <h4 class="fw-bold text-success">HR Maesai</h4>
    <p class="text-muted mb-4">ระบบบริหารงานบุคคล</p>
    
    <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

    <form method="POST">
        <div class="form-floating mb-3">
            <input type="text" name="username" class="form-control" id="floatingInput" placeholder="Username" required autofocus>
            <label for="floatingInput"><i class="fas fa-user me-2"></i>ชื่อผู้ใช้</label>
        </div>
        <div class="form-floating mb-4">
            <input type="password" name="password" class="form-control" id="floatingPassword" placeholder="Password" required>
            <label for="floatingPassword"><i class="fas fa-key me-2"></i>รหัสผ่าน</label>
        </div>
        <button type="submit" class="btn btn-success w-100 py-2 fw-bold shadow-sm">เข้าสู่ระบบ</button>
    </form>
    
    <div class="mt-4 border-top pt-3">
        <p class="small text-muted">ยังไม่มีบัญชีใช่ไหม?</p>
        <a href="register.php" class="btn btn-sm btn-outline-success">ลงทะเบียนบุคลากรใหม่</a>
    </div>
</div>

</body>
</html>