<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

$is_admin = isAdmin(); 
$my_id = $_SESSION['personnel_id'];

// --- ส่วนจัดการข้อมูล (PHP) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (isset($_POST['btnSave'])) {
            // [เพิ่มข้อมูล]
            // ถ้าเป็น Admin เลือกคนได้, ถ้าเป็น User บังคับเป็นตัวเอง
            $pid = ($is_admin && !empty($_POST['personnel_id'])) ? $_POST['personnel_id'] : $my_id;
            
            $stmt = $conn->prepare("INSERT INTO official_travel (personnel_id, doc_no, doc_date, type, topic, start_date, end_date, location, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'รออนุมัติ')");
            $stmt->execute([
                $pid, $_POST['doc_no'], $_POST['doc_date'], 
                $_POST['type'], $_POST['topic'], $_POST['start_date'], 
                $_POST['end_date'], $_POST['location']
            ]);
            $msg = "บันทึกข้อมูลเรียบร้อย";
            
        } elseif (isset($_POST['btnUpdate'])) {
            // [แก้ไข/อนุมัติ]
            $stmt = $conn->prepare("UPDATE official_travel SET personnel_id=?, doc_no=?, doc_date=?, type=?, topic=?, start_date=?, end_date=?, location=?, status=? WHERE id=?");
            $stmt->execute([
                $_POST['personnel_id'], $_POST['doc_no'], $_POST['doc_date'], 
                $_POST['type'], $_POST['topic'], $_POST['start_date'], 
                $_POST['end_date'], $_POST['location'], $_POST['status'], $_POST['id']
            ]);
            $msg = "อัปเดตข้อมูลเรียบร้อย";
        }
        echo "<script>alert('$msg'); window.location='official_travel.php';</script>";
    } catch (PDOException $e) {
        echo "<script>alert('Error: " . $e->getMessage() . "');</script>";
    }
}

// --- ส่วนลบข้อมูล (รวมไว้ในนี้เลย) ---
if (isset($_GET['delete_id'])) {
    $del_id = $_GET['delete_id'];
    // ถ้าเป็น User ธรรมดา ต้องเช็คว่าเป็นของตัวเองและสถานะต้องรออนุมัติเท่านั้น
    if(!$is_admin) {
        $chk = $conn->prepare("SELECT status FROM official_travel WHERE id=? AND personnel_id=?");
        $chk->execute([$del_id, $my_id]);
        $row = $chk->fetch();
        if(!$row || $row['status'] != 'รออนุมัติ') {
            echo "<script>alert('คุณไม่มีสิทธิ์ลบรายการนี้'); window.location='official_travel.php';</script>";
            exit;
        }
    }
    
    $conn->prepare("DELETE FROM official_travel WHERE id=?")->execute([$del_id]);
    echo "<script>alert('ลบข้อมูลเรียบร้อย'); window.location='official_travel.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <title>บันทึกการไปราชการ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container p-3 p-md-4 bg-white rounded shadow-sm mt-3 mb-5">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 gap-2">
        <div>
            <h3 class="mb-0 text-success fw-bold"><i class="fas fa-car-side"></i> ข้อมูลการไปราชการ</h3>
            <small class="text-muted">
                <?php echo $is_admin ? "จัดการคำสั่งไปราชการทั้งหมด" : "ประวัติการไปราชการของคุณ"; ?>
            </small>
        </div>
        <button class="btn btn-success w-100 w-md-auto shadow-sm" onclick="openModal('add')">
            <i class="fas fa-plus"></i> เพิ่มรายการใหม่
        </button>
    </div>

    <div class="table-responsive">
        <table id="travelTable" class="table table-bordered table-hover align-middle w-100 text-nowrap">
            <thead class="table-success">
                <tr>
                    <th>เลขที่คำสั่ง</th>
                    <?php if($is_admin) echo "<th>ชื่อ-นามสกุล</th>"; ?>
                    <th>เรื่อง</th>
                    <th>สถานที่</th>
                    <th>สถานะ</th>
                    <th>จัดการ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Query: Admin เห็นหมด / User เห็นแค่ตัวเอง
                $sql = "SELECT t.*, p.firstname, p.lastname, p.prefix 
                        FROM official_travel t 
                        LEFT JOIN personnel p ON t.personnel_id = p.id ";