<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $old_pass = md5($_POST['old_pass']);
    $new_pass = md5($_POST['new_pass']);
    $confirm_pass = md5($_POST['confirm_pass']);
    $admin_id = $_SESSION['admin_id'];

    // 1. เช็ครหัสเก่า
    $stmt = $conn->prepare("SELECT password FROM admin WHERE id = ?");
    $stmt->execute([$admin_id]);
    $current = $stmt->fetchColumn();

    if ($current !== $old_pass) {
        $error = "รหัสผ่านเดิมไม่ถูกต้อง";
    } elseif ($new_pass !== $confirm_pass) {
        $error = "รหัสผ่านใหม่ไม่ตรงกัน";
    } else {
        // 2. อัปเดต
        $stmt = $conn->prepare("UPDATE admin SET password = ? WHERE id = ?");
        $stmt->execute([$new_pass, $admin_id]);
        $success = "เปลี่ยนรหัสผ่านเรียบร้อยแล้ว";
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>เปลี่ยนรหัสผ่าน - โรงเรียนแม่สายประสิทธิ์ศาสตร์</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

    <?php include 'navbar.php'; ?>

    <div class="container mt-5 mb-5" style="max-width: 500px;">
        <div class="card shadow border-0">
            <div class="card-header bg-success text-white py-3">
                <h5 class="mb-0"><i class="fas fa-key me-2"></i> เปลี่ยนรหัสผ่านผู้ดูแลระบบ</h5>
            </div>
            <div class="card-body p-4">
                <?php if(isset($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> <?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(isset($success)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> <?php echo $success; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label fw-bold">รหัสผ่านเดิม</label>
                        <input type="password" name="old_pass" class="form-control" placeholder="กรอกรหัสผ่านปัจจุบัน" required>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label class="form-label fw-bold">รหัสผ่านใหม่</label>
                        <input type="password" name="new_pass" class="form-control" placeholder="กรอกรหัสผ่านใหม่" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">ยืนยันรหัสผ่านใหม่</label>
                        <input type="password" name="confirm_pass" class="form-control" placeholder="กรอกรหัสผ่านใหม่อีกครั้ง" required>
                    </div>
                    <div class="d-grid gap-2 mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> บันทึกการเปลี่ยนแปลง
                        </button>
                        <a href="index.php" class="btn btn-outline-secondary">ยกเลิก</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include 'footer.php'; ?>

    </body>
</html>