<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

$is_admin = isAdmin(); 
$my_id = $_SESSION['personnel_id'];

// --- 1. เตรียมตัวแปรสำหรับการค้นหา ---
$search_text = isset($_GET['search']) ? $_GET['search'] : '';
$search_pos = isset($_GET['position']) ? $_GET['position'] : '';
$search_dept = isset($_GET['department']) ? $_GET['department'] : '';

// รายการตำแหน่งสำหรับ Dropdown
$positions_list = [
    'ผู้อำนวยการ', 'รองผู้อำนวยการ', 'ครู', 'ครูผู้ช่วย', 
    'พนักงานราชการ', 'ครูอัตราจ้าง', 'อัตราจ้าง', 
    'ลูกจ้างประจำ', 'ลูกจ้างชั่วคราว', 'จ้างเหมาบริการ', 
    'เจ้าหน้าที่', 'ธุรการ', 'นักการภารโรง'
];

// รายการกลุ่มสาระฯ สำหรับ Dropdown
$departments_list = [
    'ภาษาไทย', 'คณิตศาสตร์', 'วิทยาศาสตร์และเทคโนโลยี', 
    'สังคมศึกษา ศาสนา และวัฒนธรรม', 'สุขศึกษาและพลศึกษา', 
    'ศิลปะ', 'การงานอาชีพ', 'ภาษาต่างประเทศ', 
    'กิจกรรมพัฒนาผู้เรียน', 'ฝ่ายบริหารทั่วไป', 
    'ฝ่ายบริหารวิชาการ', 'ฝ่ายบริหารงบประมาณ', 
    'ฝ่ายบริหารงานบุคคล', 'เจ้าหน้าที่สนับสนุนการสอน'
];
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ทะเบียนบุคลากร</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .table-img { width: 40px; height: 40px; object-fit: cover; border-radius: 50%; }
        /* ปรับแต่งกล่อง Filter */
        .filter-card {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .form-label-sm { font-size: 0.85rem; font-weight: bold; color: #555; margin-bottom: 0.2rem; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container-fluid p-3 p-md-4 bg-white rounded shadow-sm mt-3">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 gap-2">
        <div class="text-center text-md-start">
            <h3 class="mb-0 text-success fw-bold"><i class="fas fa-users"></i> ทะเบียนบุคลากร</h3>
            <small class="text-muted"><?php echo $is_admin ? "จัดการข้อมูลทั้งหมด" : "ข้อมูลส่วนตัวของคุณ"; ?></small>
        </div>
        
        <?php if($is_admin): ?>
        <div class="d-flex flex-wrap justify-content-center gap-2">
            <a href="print_list.php" target="_blank" class="btn btn-outline-dark btn-sm"><i class="fas fa-print"></i> พิมพ์</a>
            <a href="export.php?act=excel" class="btn btn-success btn-sm"><i class="fas fa-file-excel"></i> Excel</a>
            <a href="personnel_edit.php" class="btn btn-primary btn-sm"><i class="fas fa-user-plus"></i> เพิ่ม</a>
        </div>
        <?php endif; ?>
    </div>
    
    <?php if($is_admin): ?>
    <div class="filter-card shadow-sm">
        <form method="GET" action="">
            <div class="row g-2 align-items-end">
                <div class="col-md-3">
                    <label class="form-label-sm">ค้นหาชื่อ-สกุล</label>
                    <div class="input-group">
                        <span class="input-group-text bg-white"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" name="search" class="form-control" placeholder="พิมพ์ชื่อ..." value="<?php echo htmlspecialchars($search_text); ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="form-label-sm">ตำแหน่ง</label>
                    <select name="position" class="form-select">
                        <option value="">-- ทั้งหมด --</option>
                        <?php foreach($positions_list as $pos): ?>
                            <option value="<?php echo $pos; ?>" <?php if($search_pos == $pos) echo 'selected'; ?>><?php echo $pos; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label-sm">กลุ่มสาระฯ / ฝ่าย</label>
                    <select name="department" class="form-select">
                        <option value="">-- ทั้งหมด --</option>
                        <?php foreach($departments_list as $dept): ?>
                            <option value="<?php echo $dept; ?>" <?php if($search_dept == $dept) echo 'selected'; ?>><?php echo $dept; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3 d-flex gap-2">
                    <button type="submit" class="btn btn-primary w-100 fw-bold"><i class="fas fa-filter"></i> กรองข้อมูล</button>
                    <?php if($search_text!='' || $search_pos!='' || $search_dept!=''): ?>
                        <a href="personnel.php" class="btn btn-secondary" title="ล้างค่า"><i class="fas fa-undo"></i></a>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>
    <?php endif; ?>
    
    <div class="table-responsive">
        <table id="personnelTable" class="table table-hover align-middle w-100 text-nowrap">
            <thead class="table-dark">
                <tr>
                    <th width="5%">รูป</th>
                    <th>ชื่อ-นามสกุล</th>
                    <th>ตำแหน่ง</th>
                    <th>กลุ่มสาระฯ</th>
                    <th>เบอร์โทร</th>
                    <th>สถานะ</th>
                    <th>จัดการ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($is_admin) {
                    // --- 3. ปรับปรุง SQL ตามเงื่อนไขการกรอง ---
                    $sql = "SELECT * FROM personnel WHERE 1=1";
                    $params = [];

                    if (!empty($search_text)) {
                        $sql .= " AND (firstname LIKE ? OR lastname LIKE ? OR nickname LIKE ?)";
                        $params[] = "%$search_text%";
                        $params[] = "%$search_text%";
                        $params[] = "%$search_text%";
                    }
                    if (!empty($search_pos)) {
                        $sql .= " AND position_type = ?";
                        $params[] = $search_pos;
                    }
                    if (!empty($search_dept)) {
                        $sql .= " AND department = ?";
                        $params[] = $search_dept;
                    }

                    $sql .= " ORDER BY department ASC, code ASC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute($params);

                } else {
                    $sql = "SELECT * FROM personnel WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute([$my_id]);
                }

                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $img = !empty($row['image']) ? "uploads/{$row['image']}" : "uploads/default.png";
                    $st_color = ($row['status'] == 'ปกติ') ? 'success' : 'secondary';
                    
                    echo "<tr>";
                    echo "<td><img src='{$img}' class='table-img'></td>";
                    echo "<td class='fw-bold'>{$row['prefix']}{$row['firstname']} {$row['lastname']}</td>";
                    echo "<td><small>{$row['position_type']}</small></td>";
                    echo "<td><small>{$row['department']}</small></td>";
                    echo "<td><small>{$row['phone']}</small></td>";
                    echo "<td><span class='badge bg-{$st_color}'>{$row['status']}</span></td>";
                    echo "<td>
                        <div class='btn-group'>
                            <a href='profile.php?id={$row['id']}' class='btn btn-sm btn-info text-white' title='ดูข้อมูล'><i class='fas fa-eye'></i></a>
                            
                            <a href='personnel_edit.php?id={$row['id']}' class='btn btn-sm btn-warning' title='แก้ไข'><i class='fas fa-edit'></i></a>";
                    
                    if($is_admin) {
                        echo "<a href='delete_personnel.php?id={$row['id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('ยืนยันการลบ?')\" title='ลบ'><i class='fas fa-trash'></i></a>";
                    }
                    echo "</div></td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        $('#personnelTable').DataTable({
            "language": { "url": "//cdn.datatables.net/plug-ins/1.13.4/i18n/th.json" },
            "pageLength": 25,
            "scrollX": true,
            "searching": false // ปิดช่องค้นหาของ DataTables (เพราะเรามีกล่อง Filter ด้านบนแล้ว)
        });
    });
</script>
</body>
</html>