<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

$is_admin = isAdmin();
$my_id = $_SESSION['personnel_id'];

// --- 1. ประกาศตัวแปรเริ่มต้น ---
$data = [
    'id' => '', 'code' => '', 'direct_pay_code' => '',
    'id_card' => '', 'prefix' => 'นาย', 'prefix_en' => '', 
    'firstname' => '', 'lastname' => '', 'nickname' => '',
    'firstname_en' => '', 'lastname_en' => '',
    'position_type' => '', 'academic_standing' => '', 'department' => '', 'phone' => '',
    'email' => '', 'status' => 'ปกติ', 'image' => 'default.png',
    'birthdate' => '', 'address' => '', 'official_start_date' => '', 
    'start_date' => '', 'budget_source' => ''
];
$educations = [];

$edit_id = isset($_GET['id']) ? $_GET['id'] : (!$is_admin ? $my_id : null);
if ($edit_id && !$is_admin && $edit_id != $my_id) $edit_id = $my_id;

if ($edit_id) {
    $stmt = $conn->prepare("SELECT * FROM personnel WHERE id = ?");
    $stmt->execute([$edit_id]);
    $fetched = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($fetched) $data = array_merge($data, $fetched);

    $stmt_edu = $conn->prepare("SELECT * FROM personnel_education WHERE personnel_id = ? ORDER BY edu_date DESC");
    $stmt_edu->execute([$edit_id]);
    $educations = $stmt_edu->fetchAll(PDO::FETCH_ASSOC);
}

// --- 2. บันทึกข้อมูล ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['btnSave'])) {
    try {
        $image_name = $_POST['old_image'];
        if (!empty($_FILES['image']['name'])) {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $new_name = uniqid() . "." . $ext;
            if(move_uploaded_file($_FILES['image']['tmp_name'], "uploads/" . $new_name)) $image_name = $new_name;
        }

        $params = [
            $_POST['code'], $_POST['direct_pay_code'], $_POST['id_card'], 
            $_POST['prefix'], $_POST['prefix_en'], 
            $_POST['firstname'], $_POST['lastname'], 
            $_POST['nickname'], $_POST['firstname_en'], $_POST['lastname_en'],
            $_POST['position_type'], $_POST['academic_standing'], $_POST['department'], 
            $_POST['phone'], $_POST['email'], $_POST['status'], $image_name, 
            $_POST['birthdate'], $_POST['address'], $_POST['official_start_date'], 
            $_POST['start_date'], $_POST['budget_source']
        ];

        if ($edit_id) {
            $sql = "UPDATE personnel SET code=?, direct_pay_code=?, id_card=?, prefix=?, prefix_en=?, firstname=?, lastname=?, nickname=?, firstname_en=?, lastname_en=?, position_type=?, academic_standing=?, department=?, phone=?, email=?, status=?, image=?, birthdate=?, address=?, official_start_date=?, start_date=?, budget_source=? WHERE id=?";
            $params[] = $edit_id;
        } else {
            $sql = "INSERT INTO personnel (code, direct_pay_code, id_card, prefix, prefix_en, firstname, lastname, nickname, firstname_en, lastname_en, position_type, academic_standing, department, phone, email, status, image, birthdate, address, official_start_date, start_date, budget_source) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $redirect_id = $edit_id ?: $conn->lastInsertId();
        echo "<script>alert('บันทึกข้อมูลเรียบร้อย'); window.location='personnel_edit.php?id=$redirect_id';</script>";
        exit;
    } catch (PDOException $e) { echo "<script>alert('Error: " . $e->getMessage() . "');</script>"; }
}
?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>แก้ไขข้อมูลบุคลากร</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .preview-img { width: 150px; height: 150px; object-fit: cover; border-radius: 10px; border: 2px solid #ddd; }
        .section-title { border-bottom: 2px solid #198754; padding-bottom: 10px; margin-bottom: 20px; margin-top: 30px; color: #198754; font-weight: bold; }
        label.fw-bold { color: #333; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container p-4 bg-white rounded shadow-sm mt-3 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-primary fw-bold mb-0"><i class="fas fa-user-edit"></i> <?php echo $edit_id ? "แก้ไขข้อมูล" : "เพิ่มบุคลากรใหม่"; ?></h3>
        <a href="profile.php?id=<?php echo $edit_id; ?>" class="btn btn-secondary btn-sm">ดูโปรไฟล์</a>
    </div>
    
    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="old_image" value="<?php echo $data['image']; ?>">
        
        <h5 class="section-title">ข้อมูลส่วนตัว</h5>
        <div class="row g-3">
            <div class="col-12 text-center mb-3">
                <img src="uploads/<?php echo $data['image']; ?>" class="preview-img mb-2 shadow-sm"><br>
                <div class="col-md-4 mx-auto"><input type="file" name="image" class="form-control form-control-sm"></div>
            </div>

            <div class="col-md-4"><label class="form-label fw-bold">เลขที่ตำแหน่ง</label><input type="text" name="code" class="form-control" value="<?php echo $data['code']; ?>"></div>
            <div class="col-md-4"><label class="form-label fw-bold">เลขที่ตำแหน่งจ่ายตรง</label><input type="text" name="direct_pay_code" class="form-control" value="<?php echo $data['direct_pay_code']; ?>"></div>
            
            <div class="col-md-4">
                <label class="form-label fw-bold">เลขบัตรประชาชน</label> <input type="text" name="id_card" class="form-control" value="<?php echo $data['id_card']; ?>" required>
            </div>

            <div class="col-md-2">
                <label class="form-label fw-bold">คำนำหน้า (TH)</label>
                <select name="prefix" class="form-select">
                    <option <?php if($data['prefix']=='นาย') echo 'selected'; ?>>นาย</option>
                    <option <?php if($data['prefix']=='นาง') echo 'selected'; ?>>นาง</option>
                    <option <?php if($data['prefix']=='นางสาว') echo 'selected'; ?>>นางสาว</option>
                    <option <?php if($data['prefix']=='ว่าที่ร้อยตรี') echo 'selected'; ?>>ว่าที่ร้อยตรี</option>
                </select>
            </div>
            <div class="col-md-4"><label class="form-label fw-bold">ชื่อ (ไทย)</label><input type="text" name="firstname" class="form-control" value="<?php echo $data['firstname']; ?>" required></div>
            <div class="col-md-4"><label class="form-label fw-bold">นามสกุล (ไทย)</label><input type="text" name="lastname" class="form-control" value="<?php echo $data['lastname']; ?>" required></div>
            <div class="col-md-2"><label class="form-label fw-bold">ชื่อเล่น</label><input type="text" name="nickname" class="form-control" value="<?php echo $data['nickname']; ?>"></div>

            <div class="col-md-2">
                <label class="form-label fw-bold">Prefix (EN)</label>
                <select name="prefix_en" class="form-select">
                    <option value="">-- Select --</option>
                    <option <?php if($data['prefix_en']=='Mr.') echo 'selected'; ?>>Mr.</option>
                    <option <?php if($data['prefix_en']=='Mrs.') echo 'selected'; ?>>Mrs.</option>
                    <option <?php if($data['prefix_en']=='Miss') echo 'selected'; ?>>Miss</option>
                </select>
            </div>
            <div class="col-md-5"><label class="form-label fw-bold">Firstname (EN)</label><input type="text" name="firstname_en" class="form-control" value="<?php echo $data['firstname_en']; ?>"></div>
            <div class="col-md-5"><label class="form-label fw-bold">Lastname (EN)</label><input type="text" name="lastname_en" class="form-control" value="<?php echo $data['lastname_en']; ?>"></div>
        </div>

        <h5 class="section-title">ข้อมูลการทำงาน</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label fw-bold">ตำแหน่ง</label>
                <select name="position_type" class="form-select">
                    <option value="">-- เลือกตำแหน่ง --</option>
                    <?php 
                    $positions = ['ผู้อำนวยการ', 'รองผู้อำนวยการ', 'ครู', 'ครูผู้ช่วย', 'พนักงานราชการ', 'ครูอัตราจ้าง', 'อัตราจ้าง', 'ลูกจ้างประจำ', 'ลูกจ้างชั่วคราว', 'จ้างเหมาบริการ', 'เจ้าหน้าที่ธุรการ', 'นักการภารโรง'];
                    foreach($positions as $p) {
                        $sel = ($data['position_type'] == $p) ? 'selected' : '';
                        echo "<option value='$p' $sel>$p</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label fw-bold">วิทยฐานะ</label>
                <select name="academic_standing" class="form-select">
                    <option value="">-- ไม่มี --</option>
                    <?php 
                    $academics = ['ชำนาญการ', 'ชำนาญการพิเศษ', 'เชี่ยวชาญ', 'เชี่ยวชาญพิเศษ'];
                    foreach($academics as $ac) {
                        $sel = ($data['academic_standing'] == $ac) ? 'selected' : '';
                        echo "<option value='$ac' $sel>$ac</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label fw-bold">กลุ่มสาระการเรียนรู้ / ฝ่าย</label>
                <select name="department" class="form-select">
                    <option value="">-- เลือกกลุ่มสาระฯ --</option>
                    <?php 
                    $depts = [
                        'ภาษาไทย', 
                        'คณิตศาสตร์', 
                        'วิทยาศาสตร์และเทคโนโลยี', 
                        'สังคมศึกษา ศาสนา และวัฒนธรรม', 
                        'สุขศึกษาและพลศึกษา', 
                        'ศิลปะ', 
                        'การงานอาชีพ', 
                        'ภาษาต่างประเทศ', 
                        'กิจกรรมพัฒนาผู้เรียน',
                        'ฝ่ายบริหารทั่วไป',
                        'ฝ่ายบริหารวิชาการ',
                        'ฝ่ายบริหารงบประมาณ',
                        'ฝ่ายบริหารงานบุคคล',
                        'เจ้าหน้าที่สนับสนุนการสอน'
                    ];
                    foreach($depts as $d) {
                        $sel = ($data['department'] == $d) ? 'selected' : '';
                        echo "<option value='$d' $sel>$d</option>";
                    }
                    ?>
                </select>
            </div>
            
            <div class="col-md-6">
                <label class="form-label fw-bold">งบประมาณค่าจ้าง</label> 
                <select name="budget_source" class="form-select">
                    <option value="">-- เลือก --</option>
                    <option <?php if($data['budget_source']=='กรมบัญชีกลาง(ข้าราชการ)') echo 'selected'; ?>>กรมบัญชีกลาง(ข้าราชการ)</option>
                    <option <?php if($data['budget_source']=='เขตพื้นที่การศึกษา') echo 'selected'; ?>>เขตพื้นที่การศึกษา</option>
                    <option <?php if($data['budget_source']=='โรงเรียน-เงินบำรุงการศึกษา') echo 'selected'; ?>>โรงเรียน-เงินบำรุงการศึกษา</option>
                    <option <?php if($data['budget_source']=='โรงเรียน-เงินบำรุงการศึกษาMP') echo 'selected'; ?>>โรงเรียน-เงินบำรุงการศึกษาMP</option>
                    <option <?php if($data['budget_source']=='โรงเรียน-เงินอุดหนุนรายจ่าย') echo 'selected'; ?>>โรงเรียน-เงินอุดหนุนรายจ่าย</option>
                    <option <?php if($data['budget_source']=='โรงเรียน-รายได้สถานศึกษาMP') echo 'selected'; ?>>โรงเรียน-รายได้สถานศึกษาMP</option>
                </select>
            </div>
            
            <div class="col-md-6"><label class="form-label fw-bold">เริ่มรับราชการ</label><input type="date" name="official_start_date" class="form-control" value="<?php echo $data['official_start_date']; ?>"></div>
            <div class="col-md-6"><label class="form-label fw-bold">เริ่มงานที่นี่</label><input type="date" name="start_date" class="form-control" value="<?php echo $data['start_date']; ?>"></div>
        </div>

        <h5 class="section-title">ข้อมูลติดต่อ</h5>
        <div class="row g-3">
            <div class="col-md-4"><label class="form-label fw-bold">วันเกิด</label><input type="date" name="birthdate" class="form-control" value="<?php echo $data['birthdate']; ?>"></div>
            <div class="col-md-4"><label class="form-label fw-bold">เบอร์โทร</label><input type="text" name="phone" class="form-control" value="<?php echo $data['phone']; ?>"></div>
            <div class="col-md-4"><label class="form-label fw-bold">อีเมล</label><input type="email" name="email" class="form-control" value="<?php echo $data['email']; ?>"></div>
            <div class="col-12"><label class="form-label fw-bold">ที่อยู่</label><textarea name="address" class="form-control" rows="1"><?php echo $data['address']; ?></textarea></div>
            
            <div class="col-md-6">
                <label class="form-label fw-bold">สถานะ</label>
                <select name="status" class="form-select">
                    <option <?php if($data['status']=='ปกติ') echo 'selected'; ?>>ปกติ</option>
                    <option <?php if($data['status']=='ลาออก') echo 'selected'; ?>>ลาออก</option>
                </select>
            </div>

            <div class="col-12 mt-4">
                <button type="submit" name="btnSave" class="btn btn-success w-100 py-3 fw-bold shadow-sm">บันทึกข้อมูลทั้งหมด</button>
            </div>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>