<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

// ตั้งค่า Timezone
date_default_timezone_set('Asia/Bangkok');
$today = date('Y-m-d');

// --- 1. กำหนดหมวดหมู่ตำแหน่ง ---
$categories = [
    'ผู้บริหารสถานศึกษา' => ['ผู้อำนวยการ', 'รองผู้อำนวยการ'],
    'ข้าราชการครู' => ['ครู', 'ครูผู้ช่วย'],
    'พนักงานราชการ' => ['พนักงานราชการ'],
    'ครูอัตราจ้าง' => ['อัตราจ้าง', 'ครูอัตราจ้าง'],
    'ลูกจ้างประจำ' => ['ลูกจ้างประจำ'],
    'ลูกจ้างชั่วคราว' => ['ลูกจ้างชั่วคราว'],
    'จ้างเหมาบริการ' => ['จ้างเหมาบริการ']
];

// ฟังก์ชันดึงข้อมูลตามกลุ่มตำแหน่ง
function getPersonnelByGroup($conn, $types) {
    $placeholders = implode(',', array_fill(0, count($types), '?'));
    $sql = "SELECT * FROM personnel WHERE status = 'ปกติ' AND position_type IN ($placeholders) ORDER BY position_type DESC, code ASC";
    $stmt = $conn->prepare($sql);
    $stmt->execute($types);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// ฟังก์ชันนับแยกเพศ
function countGender($data) {
    $male = 0;
    $female = 0;
    foreach ($data as $row) {
        if ($row['prefix'] == 'นาย' || strpos($row['prefix'], 'ว่าที่ร้อยตรี') !== false || strpos($row['prefix'], 'พระ') !== false || strpos($row['prefix'], 'เด็กชาย') !== false) {
            $male++;
        } else {
            $female++;
        }
    }
    return ['male' => $male, 'female' => $female];
}

?>

<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>รายงานสรุปข้อมูลบุคลากร</title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body { font-family: 'Sarabun', sans-serif; font-size: 14pt; background: #eee; }
        .page-a4 {
            width: 210mm; min-height: 297mm; padding: 15mm 20mm; margin: 10mm auto;
            background: white; box-shadow: 0 0 10px rgba(0,0,0,0.1); position: relative;
        }
        h3, h4, h5 { font-weight: bold; margin: 0; text-align: center; }
        .table-custom { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .table-custom th, .table-custom td { border: 1px solid #333; padding: 8px; font-size: 12pt; vertical-align: middle; }
        .table-custom th { background-color: #f0f0f0; text-align: center; }
        .group-header { background-color: #e9ecef; font-weight: bold; text-align: left !important; padding-left: 15px !important; }
        
        .summary-box { border: 1px solid #333; padding: 15px; margin-bottom: 20px; border-radius: 5px; }
        
        @media print {
            body { background: none; margin: 0; }
            .page-a4 { width: 100%; margin: 0; padding: 10mm; box-shadow: none; border: none; }
            .no-print { display: none !important; }
            .page-break { page-break-before: always; }
        }
    </style>
</head>
<body>

<div class="no-print text-center py-3 bg-dark fixed-top">
    <button onclick="window.print()" class="btn btn-warning fw-bold"><i class="fas fa-print"></i> สั่งพิมพ์ (Print)</button>
    <button onclick="window.close()" class="btn btn-light ms-2">ปิดหน้าต่าง</button>
</div>
<div style="height: 60px;" class="no-print"></div>

<div class="page-a4">
    <h3>ทำเนียบและสถิติบุกร - โรงเรียนแม่สายประสิทธิ์ศาสตร์</h3>
    <p class="text-center mb-4">ข้อมูล ณ วันที่ <?php echo DateThai($today); ?></p>

    <div class="summary-box">
        <h5 class="mb-3">สรุปจำนวนบุคลากรแยกประเภทและเพศ</h5>
        <table class="table-custom">
            <thead>
                <tr>
                    <th width="40%">ประเภทบุคลากร</th>
                    <th width="20%">ชาย (คน)</th>
                    <th width="20%">หญิง (คน)</th>
                    <th width="20%">รวม (คน)</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $grand_total = 0; $grand_male = 0; $grand_female = 0;
                foreach ($categories as $cat_name => $types): 
                    $personnel = getPersonnelByGroup($conn, $types);
                    $count = countGender($personnel);
                    $total = count($personnel);
                    
                    $grand_total += $total;
                    $grand_male += $count['male'];
                    $grand_female += $count['female'];
                ?>
                <tr>
                    <td style="text-align: left; padding-left: 15px;"><?php echo $cat_name; ?></td>
                    <td class="text-center"><?php echo $count['male']; ?></td>
                    <td class="text-center"><?php echo $count['female']; ?></td>
                    <td class="text-center fw-bold"><?php echo $total; ?></td>
                </tr>
                <?php endforeach; ?>
                <tr style="background-color: #ddd; font-weight: bold;">
                    <td class="text-center">รวมทั้งสิ้น</td>
                    <td class="text-center"><?php echo $grand_male; ?></td>
                    <td class="text-center"><?php echo $grand_female; ?></td>
                    <td class="text-center"><?php echo $grand_total; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <h5 class="mt-4 mb-3 text-start">รายชื่อบุคลากรจำแนกตามตำแหน่ง</h5>
    
    <table class="table-custom">
        <thead>
            <tr>
                <th width="5%">ลำดับ</th>
                <th width="10%">รหัส</th>
                <th width="30%">ชื่อ-นามสกุล</th>
                <th width="25%">ตำแหน่ง</th>
                <th width="15%">เบอร์โทร</th>
                <th width="15%">หมายเหตุ</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            foreach ($categories as $cat_name => $types): 
                $personnel_list = getPersonnelByGroup($conn, $types);
                if (count($personnel_list) > 0):
            ?>
                <tr>
                    <td colspan="6" class="group-header"><?php echo $cat_name; ?> (<?php echo count($personnel_list); ?> คน)</td>
                </tr>
                
                <?php 
                    $i = 1;
                    foreach ($personnel_list as $p): 
                        $fullname = $p['prefix'] . $p['firstname'] . ' ' . $p['lastname'];
                ?>
                <tr>
                    <td class="text-center"><?php echo $i++; ?></td>
                    <td class="text-center"><?php echo $p['code']; ?></td>
                    <td><?php echo $fullname; ?></td>
                    <td class="text-center"><?php echo $p['position_type']; ?></td>
                    <td class="text-center"><?php echo $p['phone']; ?></td>
                    <td class="text-center"></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; endforeach; ?>
        </tbody>
    </table>
    
    <div class="mt-5 text-end">
        <p>ลงชื่อ ....................................................... ผู้จัดทำข้อมูล</p>
        <p>วันที่พิมพ์: <?php echo DateThai(date('Y-m-d')); ?></p>
    </div>
</div>

</body>
</html>