<?php 
require_once 'auth.php'; 
require_once 'db.php'; 

$is_admin = isAdmin();
$view_id = isset($_GET['id']) ? $_GET['id'] : $_SESSION['personnel_id'];

// Security Check
if (!$is_admin && $view_id != $_SESSION['personnel_id']) {
    $view_id = $_SESSION['personnel_id'];
}

if (!$view_id) exit("ไม่พบข้อมูล");

// ดึงข้อมูล
$stmt = $conn->prepare("SELECT * FROM personnel WHERE id = ?");
$stmt->execute([$view_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$stmt_edu = $conn->prepare("SELECT * FROM personnel_education WHERE personnel_id = ? ORDER BY edu_date DESC");
$stmt_edu->execute([$view_id]);
$educations = $stmt_edu->fetchAll(PDO::FETCH_ASSOC);

// คำนวณวันเกษียณ
$retire_date = "-";
$age = "-";
if(!empty($user['birthdate'])) {
    $birth_year = date('Y', strtotime($user['birthdate']));
    $retire_year = $birth_year + 60;
    $retire_date = "30 กันยายน " . ($retire_year + 543);
    
    // คำนวณอายุ
    $dob = new DateTime($user['birthdate']);
    $now = new DateTime();
    $diff = $now->diff($dob);
    $age = $diff->y . " ปี";
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>พิมพ์ประวัติ - <?php echo $user['firstname']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        /* ตั้งค่าฟอนต์ 16pt */
        body { 
            font-family: 'Sarabun', sans-serif; 
            font-size: 16pt; 
            color: #000; 
            background: #eee; 
            line-height: 1.1; /* ลดระยะบรรทัดลงอีกนิด (จาก 1.15) เพื่อดึงเนื้อหาขึ้น */
        }

        .page-a4 {
            width: 210mm;
            height: 296mm; 
            padding: 5mm 15mm 0mm 15mm; /* ลด Padding ล่างเหลือ 0 */
            margin: 10mm auto;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            position: relative;
            box-sizing: border-box;
            overflow: hidden; 
        }

        /* โลโก้ */
        .logo-container {
            text-align: center;
            margin-bottom: 0px; /* ตัดระยะห่างล่าง */
        }
        .school-logo {
            width: 70px; /* ลดขนาดโลโก้นิดนึงเพื่อประหยัดที่ */
            height: auto;
        }

        .header-title { text-align: center; font-weight: bold; font-size: 20pt; margin: 0; }
        .header-subtitle { text-align: center; font-size: 16pt; font-weight: bold; margin-bottom: 5px; }
        
        /* Layout */
        .top-section {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .personal-info {
            width: 75%; 
            padding-right: 10px;
        }
        .photo-wrapper {
            width: 25%; 
            display: flex;
            justify-content: flex-end;
            padding-top: 5px; /* ดึงรูปขึ้น */
        }
        .photo-box {
            width: 3.5cm;
            height: 4.5cm;
            border: 1px solid #000;
            padding: 2px;
        }
        .photo-box img { width: 100%; height: 100%; object-fit: cover; }

        .section-header {
            font-weight: bold;
            font-size: 18pt;
            border-bottom: 1px solid #000;
            margin-top: 3px; /* ลดระยะห่างบน */
            margin-bottom: 2px; /* ลดระยะห่างล่าง */
        }

        /* ข้อมูล */
        .data-row { margin-bottom: 0px; display: flex; align-items: baseline; } /* ตัดระยะห่างระหว่างบรรทัด */
        .data-label { font-weight: bold; width: 165px; flex-shrink: 0; }
        .data-value { flex-grow: 1; border-bottom: 1px dotted #999; padding-left: 5px; white-space: nowrap; overflow: hidden; }

        /* ตาราง */
        table { width: 100%; border-collapse: collapse; margin-top: 2px; margin-bottom: 2px; }
        th, td { border: 1px solid #000; padding: 2px 5px; text-align: center; vertical-align: middle; font-size: 15pt; line-height: 1.1; }
        th { background-color: #f0f0f0; font-weight: bold; }
        td { text-align: left; }
        td.center { text-align: center; }

        /* ส่วนลงชื่อ */
        .signature-section { 
            margin-top: 2px; /* ดึงขึ้นให้ชิดตารางที่สุด */
            float: right; 
            width: 50%; 
            text-align: center; 
            font-size: 16pt; 
            line-height: 1.25;
        }
        .signature-section p { margin-bottom: 5px; } /* ลดระยะห่างระหว่างบรรทัดเซ็นชื่อ */

        @media print {
            body { background: none; margin: 0; }
            .page-a4 { margin: 0; border: none; box-shadow: none; width: 100%; height: 100%; padding: 5mm 15mm; } 
            .no-print { display: none !important; }
            @page { size: A4 portrait; margin: 0; } 
        }
    </style>
</head>
<body>

<div class="no-print text-center py-3 bg-dark fixed-top">
    <button onclick="window.print()" class="btn btn-warning fw-bold"><i class="fa fa-print"></i> สั่งพิมพ์ (Print)</button>
    <button onclick="window.close()" class="btn btn-light ms-2">ปิดหน้าต่าง</button>
</div>
<div style="height: 60px;" class="no-print"></div>

<div class="page-a4">
    <div class="logo-container">
        <img src="https://hr.maesai.ac.th/uploads/logo.png" alt="Logo" class="school-logo">
    </div>

    <div class="header-title">ประวัติข้าราชการครูและบุคลากรทางการศึกษา</div>
    <div class="header-subtitle">โรงเรียนแม่สายประสิทธิ์ศาสตร์</div>

    <div class="top-section">
        <div class="personal-info">
            <div class="section-header">1. ข้อมูลส่วนตัว</div>
            <div class="data-row">
                <span class="data-label">ชื่อ-นามสกุล (ไทย):</span>
                <span class="data-value">
                    <?php echo $user['prefix'] . $user['firstname'] . " " . $user['lastname']; ?>
                    <?php if(!empty($user['nickname'])) echo " ({$user['nickname']})"; ?>
                </span>
            </div>
            <div class="data-row">
                <span class="data-label">ชื่อ-นามสกุล (อังกฤษ):</span>
                <span class="data-value">
                    <?php echo trim(($user['prefix_en'] ?? '') . " " . ($user['firstname_en'] ?? '') . " " . ($user['lastname_en'] ?? '')); ?>
                </span>
            </div>
            <div class="data-row">
                <span class="data-label">เลขบัตรประชาชน:</span>
                <span class="data-value"><?php echo $user['id_card']; ?></span>
            </div>
            <div class="data-row">
                <span class="data-label">วันเดือนปีเกิด:</span>
                <span class="data-value"><?php echo DateThai($user['birthdate']); ?> (อายุ <?php echo $age; ?>)</span>
            </div>
            <div class="data-row">
                <span class="data-label">วันเกษียณอายุ:</span>
                <span class="data-value"><?php echo $retire_date; ?></span>
            </div>
            <div class="data-row">
                <span class="data-label">ที่อยู่ปัจจุบัน:</span>
                <span class="data-value" style="font-size: 15pt;"><?php echo $user['address']; ?></span>
            </div>
            <div class="data-row">
                <span class="data-label">เบอร์โทรศัพท์:</span>
                <span class="data-value"><?php echo $user['phone']; ?></span>
            </div>
            <div class="data-row">
                <span class="data-label">อีเมล:</span>
                <span class="data-value"><?php echo $user['email']; ?></span>
            </div>
        </div>
        
        <div class="photo-wrapper">
            <div class="photo-box">
                <?php if(!empty($user['image'])): ?>
                    <img src="uploads/<?php echo $user['image']; ?>">
                <?php else: ?>
                    <div style="display:flex; align-items:center; justify-content:center; height:100%; font-size:14px; color:#ccc;">ติดรูปถ่าย</div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="section-header">2. ข้อมูลการปฏิบัติราชการ</div>
    
    <div class="row g-0">
        <div class="col-6" style="padding-right: 15px;">
            <div class="data-row">
                <span class="data-label" style="width:110px;">เลขที่ตำแหน่ง:</span>
                <span class="data-value"><?php echo $user['code']; ?></span>
            </div>
        </div>
        <div class="col-6">
            <div class="data-row">
                <span class="data-label" style="width:160px;">เลขที่ตำแหน่งจ่ายตรง:</span>
                <span class="data-value"><?php echo !empty($user['direct_pay_code']) ? $user['direct_pay_code'] : '-'; ?></span>
            </div>
        </div>
    </div>
    
    <div class="row g-0">
        <div class="col-6" style="padding-right: 15px;">
            <div class="data-row">
                <span class="data-label" style="width:90px;">ตำแหน่ง:</span>
                <span class="data-value"><?php echo $user['position_type']; ?></span>
            </div>
        </div>
        <div class="col-6">
            <div class="data-row">
                <span class="data-label" style="width:90px;">วิทยฐานะ:</span>
                <span class="data-value"><?php echo !empty($user['academic_standing']) ? $user['academic_standing'] : '-'; ?></span>
            </div>
        </div>
    </div>

    <div class="data-row">
        <span class="data-label">กลุ่มสาระฯ/ฝ่าย:</span>
        <span class="data-value"><?php echo $user['department']; ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">แหล่งงบประมาณ:</span>
        <span class="data-value"><?php echo !empty($user['budget_source']) ? $user['budget_source'] : '-'; ?></span>
    </div>
    
    <div class="row g-0">
        <div class="col-6" style="padding-right: 15px;">
            <div class="data-row">
                <span class="data-label" style="width:110px;">เริ่มรับราชการ:</span>
                <span class="data-value"><?php echo DateThai($user['official_start_date']); ?></span>
            </div>
        </div>
        <div class="col-6">
            <div class="data-row">
                <span class="data-label" style="width:100px;">เริ่มงานที่นี่:</span>
                <span class="data-value"><?php echo DateThai($user['start_date']); ?></span>
            </div>
        </div>
    </div>

    <div class="section-header">3. ประวัติการศึกษา</div>
    <table>
        <thead>
            <tr>
                <th style="width: 25%;">ระดับการศึกษา</th>
                <th style="width: 30%;">วุฒิ/สาขาวิชา</th>
                <th style="width: 30%;">สถาบันการศึกษา</th>
                <th style="width: 15%;">ปีที่จบ</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($educations as $edu): ?>
            <tr>
                <td class="center"><?php echo $edu['edu_level']; ?></td>
                <td><?php echo $edu['edu_degree']; ?><br><span style="font-size: 14pt; color: #333;"><?php echo $edu['edu_major']; ?></span></td>
                <td><?php echo $edu['edu_institute']; ?></td>
                <td class="center"><?php echo DateThai($edu['edu_date']); ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if(empty($educations)): ?>
                <tr><td colspan="4" class="center">- ไม่มีข้อมูล -</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="signature-section">
        <p>ขอรับรองว่าข้อมูลข้างต้นเป็นความจริงทุกประการ</p>
        <br> <p>(ลงชื่อ)...........................................................</p>
        <p>(<?php echo $user['prefix'] . $user['firstname'] . " " . $user['lastname']; ?>)</p>
        <p>เจ้าของประวัติ</p>
        <p>วันที่........./..................../.............</p>
    </div>
    <div style="clear: both;"></div>

</div>

</body>
</html>