<?php require_once 'auth.php'; ?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>ระบบรายงานสารสนเทศ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .report-card { transition: .3s; border: none; border-radius: 15px; }
        .report-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
        .icon-box { width: 60px; height: 60px; display: flex; align-items: center; justify-content: center; border-radius: 50%; margin-bottom: 15px; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container py-4">
    <div class="text-center mb-5">
        <h2 class="fw-bold text-success"><i class="fas fa-chart-line"></i> ระบบรายงานสารสนเทศ</h2>
        <p class="text-muted">โรงเรียนแม่สายประสิทธิ์ศาสตร์</p>
    </div>

    <div class="row g-4">
        <div class="col-md-4">
            <div class="card report-card h-100 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="icon-box bg-primary text-white mx-auto"><i class="fas fa-users fa-2x"></i></div>
                    <h5>ทำเนียบบุคลากร</h5>
                    <p class="text-muted small">รายชื่อบุคลากรทั้งหมด แยกตามกลุ่มสาระ/ฝ่าย พร้อมเบอร์โทรศัพท์</p>
                    <a href="print_list.php" target="_blank" class="btn btn-outline-primary w-100">พิมพ์รายชื่อ (A4)</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card report-card h-100 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="icon-box bg-warning text-dark mx-auto"><i class="fas fa-file-medical-alt fa-2x"></i></div>
                    <h5>สถิติการลา/มาสาย</h5>
                    <p class="text-muted small">ตรวจสอบสถิติการลาและการมาสายประจำเดือน</p>
                    <a href="leaves.php" class="btn btn-outline-warning w-100">ดูข้อมูล</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card report-card h-100 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="icon-box bg-danger text-white mx-auto"><i class="fas fa-user-clock fa-2x"></i></div>
                    <h5>ผู้เกษียณอายุราชการ</h5>
                    <p class="text-muted small">รายชื่อผู้ที่จะครบวาระเกษียณในปีงบประมาณนี้</p>
                    <a href="retirement.php" class="btn btn-outline-danger w-100">ดูรายชื่อ</a>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card report-card h-100 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="icon-box bg-success text-white mx-auto"><i class="fas fa-birthday-cake fa-2x"></i></div>
                    <h5>วันเกิดบุคลากร</h5>
                    <p class="text-muted small">ปฏิทินวันเกิดบุคลากรประจำเดือน เพื่อจัดกิจกรรม</p>
                    <a href="birthdays.php" class="btn btn-outline-success w-100">ดูปฏิทิน</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card report-card h-100 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="icon-box bg-success text-white mx-auto"><i class="fas fa-file-excel fa-2x"></i></div>
                    <h5>ส่งออกข้อมูล (Excel)</h5>
                    <p class="text-muted small">ดาวน์โหลดฐานข้อมูลบุคลากรทั้งหมดเพื่อนำไปใช้งานต่อ</p>
                    <a href="export.php?act=excel" class="btn btn-outline-success w-100">ดาวน์โหลด</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
</body>
</html>