<?php require_once 'auth.php'; require_once 'db.php'; ?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <title>ผู้เกษียณอายุราชการ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="container bg-white p-4 rounded shadow-sm">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3><i class="fas fa-user-clock text-danger"></i> ผู้เกษียณอายุราชการ</h3>
        <button class="btn btn-secondary no-print" onclick="window.print()"><i class="fas fa-print"></i> พิมพ์รายชื่อ</button>
    </div>

    <?php
    // คำนวณปีเกษียณ (เช่น ปีนี้ 2026 คนเกษียณคือคนที่เกิดก่อน 1 ต.ค. 1966)
    $current_year = date('Y');
    $retire_year_thai = $current_year + 543;
    $target_date = ($current_year - 60) . "-10-01";
    ?>

    <div class="alert alert-warning">
        รายชื่อผู้ที่จะเกษียณอายุราชการ ประจำปีงบประมาณ <strong><?php echo $retire_year_thai; ?></strong> (เกิดก่อน 1 ต.ค. <?php echo $retire_year_thai - 60; ?>)
    </div>

    <table class="table table-striped table-hover">
        <thead class="table-dark">
            <tr>
                <th>รหัส</th>
                <th>ชื่อ-นามสกุล</th>
                <th>ตำแหน่ง</th>
                <th>วันเกิด</th>
                <th>อายุ (ปี)</th>
                <th>วันที่เกษียณ</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql = "SELECT * FROM personnel WHERE birthdate <= '$target_date' AND status = 'ปกติ' ORDER BY birthdate ASC";
            $stmt = $conn->query($sql);
            $found = false;

            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $found = true;
                $birthDate = new DateTime($row['birthdate']);
                $today = new DateTime();
                $age = $today->diff($birthDate)->y;
                $retireDate = "30 กันยายน " . ($current_year + 543); // วันเกษียณไทย

                echo "<tr>";
                echo "<td>{$row['code']}</td>";
                echo "<td>{$row['prefix']}{$row['firstname']} {$row['lastname']}</td>";
                echo "<td>{$row['position_type']}</td>";
                echo "<td>".DateThai($row['birthdate'])."</td>";
                echo "<td class='text-danger fw-bold'>{$age}</td>";
                echo "<td>{$retireDate}</td>";
                echo "</tr>";
            }

            if (!$found) {
                echo "<tr><td colspan='6' class='text-center py-4 text-muted'>- ไม่พบผู้เกษียณในปีนี้ -</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<?php include 'footer.php'; ?>
</body>
</html>